/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.Provided;
import org.apache.reef.annotations.audience.ClientSide;
import org.apache.reef.annotations.audience.Public;
import org.apache.reef.client.ClientConfiguration;
import org.apache.reef.client.DriverLauncher;
import org.apache.reef.client.FailedJob;
import org.apache.reef.client.FailedRuntime;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;

@Unit
@Public
@Provided
@ClientSide
public final class TestDriverLauncher {
    private static final Logger LOG = Logger.getLogger(TestDriverLauncher.class.getName());
    private final DriverLauncher launcher;

    @Inject
    private TestDriverLauncher(DriverLauncher launcher) {
        this.launcher = launcher;
    }

    public static TestDriverLauncher getLauncher(Configuration runtimeConfiguration) throws BindException, InjectionException {
        Configuration clientConfiguration = ClientConfiguration.CONF.set((Impl)ClientConfiguration.ON_JOB_RUNNING, DriverLauncher.RunningJobHandler.class).set((Impl)ClientConfiguration.ON_JOB_COMPLETED, DriverLauncher.CompletedJobHandler.class).set((Impl)ClientConfiguration.ON_RUNTIME_ERROR, SilentRuntimeErrorHandler.class).set((Impl)ClientConfiguration.ON_JOB_FAILED, SilentFailedTestJobHandler.class).build();
        return (TestDriverLauncher)Tang.Factory.getTang().newInjector(new Configuration[]{runtimeConfiguration, clientConfiguration}).getInstance(TestDriverLauncher.class);
    }

    public void close() {
        this.launcher.close();
    }

    public LauncherStatus run(Configuration driverConfig) {
        return this.launcher.run(driverConfig);
    }

    public LauncherStatus run(Configuration driverConfig, long timeOut) {
        return this.launcher.run(driverConfig, timeOut);
    }

    public String toString() {
        return this.launcher.toString();
    }

    protected final class SilentFailedTestJobHandler
    implements EventHandler<FailedJob> {
        protected SilentFailedTestJobHandler() {
        }

        public void onNext(FailedJob job) {
            Optional ex = job.getReason();
            LOG.log(Level.INFO, "Received an error for job {0}: {1}", new Object[]{job.getId(), ex});
            TestDriverLauncher.this.launcher.setStatusAndNotify(LauncherStatus.failed((Optional)ex));
        }
    }

    protected final class SilentRuntimeErrorHandler
    implements EventHandler<FailedRuntime> {
        protected SilentRuntimeErrorHandler() {
        }

        public void onNext(FailedRuntime error) {
            LOG.log(Level.INFO, "Received a runtime error: {0}", error);
            TestDriverLauncher.this.launcher.setStatusAndNotify(LauncherStatus.failed((Optional)error.getReason()));
        }
    }
}

