/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.taskresubmit;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.task.FailedTask;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestUtils;
import org.apache.reef.tests.fail.task.FailTaskCall;
import org.apache.reef.tests.library.exceptions.SimulatedTaskFailure;
import org.apache.reef.tests.library.exceptions.TaskSideFailure;
import org.apache.reef.wake.EventHandler;

@Unit
class TaskResubmitDriver {
    private static final Logger LOG = Logger.getLogger(TaskResubmitDriver.class.getName());
    private int failuresSeen = 0;

    @Inject
    TaskResubmitDriver() {
    }

    private static Configuration getTaskConfiguration() {
        return TaskConfiguration.CONF.set((Impl)TaskConfiguration.TASK, FailTaskCall.class).set((Param)TaskConfiguration.IDENTIFIER, "FailTask").build();
    }

    final class TaskFailedHandler
    implements EventHandler<FailedTask> {
        TaskFailedHandler() {
        }

        public void onNext(FailedTask failedTask) {
            LOG.log(Level.INFO, "FailedTask: {0}", failedTask);
            Throwable ex = (Throwable)failedTask.getReason().get();
            if (!TestUtils.hasCause(ex, SimulatedTaskFailure.class)) {
                String msg = "Expected SimulatedTaskFailure from " + failedTask.getId();
                LOG.log(Level.SEVERE, msg, ex);
                throw new TaskSideFailure(msg, ex);
            }
            ActiveContext activeContext = (ActiveContext)failedTask.getActiveContext().get();
            if (++TaskResubmitDriver.this.failuresSeen <= 1) {
                activeContext.submitTask(TaskResubmitDriver.getTaskConfiguration());
            } else {
                activeContext.close();
            }
        }
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        public void onNext(AllocatedEvaluator allocatedEvaluator) {
            allocatedEvaluator.submitTask(TaskResubmitDriver.getTaskConfiguration());
        }
    }
}

