/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.taskcounting;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.task.CompletedTask;
import org.apache.reef.driver.task.RunningTask;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.tests.library.tasks.NoopTask;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StopTime;

@Unit
final class TaskCountingDriver {
    private final Set<String> expectedRunningTaskIds = new HashSet<String>();
    private AtomicInteger numberOfTaskSubmissions = new AtomicInteger(1000);

    @Inject
    TaskCountingDriver() {
    }

    private Configuration getTaskConfiguration(String taskId) {
        return TaskConfiguration.CONF.set((Param)TaskConfiguration.IDENTIFIER, taskId).set((Impl)TaskConfiguration.TASK, NoopTask.class).build();
    }

    final class DriverStopHandler
    implements EventHandler<StopTime> {
        DriverStopHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(StopTime stopTime) {
            Set set = TaskCountingDriver.this.expectedRunningTaskIds;
            synchronized (set) {
                if (!TaskCountingDriver.this.expectedRunningTaskIds.isEmpty()) {
                    throw new DriverSideFailure("Still expecting RunningTasks");
                }
            }
        }
    }

    final class TaskCompletedHandler
    implements EventHandler<CompletedTask> {
        TaskCompletedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(CompletedTask completedTask) {
            Set set = TaskCountingDriver.this.expectedRunningTaskIds;
            synchronized (set) {
                int nextTaskNumber = TaskCountingDriver.this.numberOfTaskSubmissions.getAndDecrement();
                if (nextTaskNumber > 0) {
                    String taskId = "Task-" + nextTaskNumber;
                    completedTask.getActiveContext().submitTask(TaskCountingDriver.this.getTaskConfiguration(taskId));
                    TaskCountingDriver.this.expectedRunningTaskIds.add(taskId);
                } else {
                    completedTask.getActiveContext().close();
                }
            }
        }
    }

    final class TaskRunningHandler
    implements EventHandler<RunningTask> {
        TaskRunningHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(RunningTask runningTask) {
            Set set = TaskCountingDriver.this.expectedRunningTaskIds;
            synchronized (set) {
                boolean isExpected = TaskCountingDriver.this.expectedRunningTaskIds.remove(runningTask.getId());
                if (!isExpected) {
                    throw new DriverSideFailure("Unexpected RunningTask: " + runningTask.getId());
                }
            }
        }
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(AllocatedEvaluator allocatedEvaluator) {
            Set set = TaskCountingDriver.this.expectedRunningTaskIds;
            synchronized (set) {
                String taskId = "Task-" + TaskCountingDriver.this.numberOfTaskSubmissions.getAndDecrement();
                Configuration taskConfiguration = TaskCountingDriver.this.getTaskConfiguration(taskId);
                allocatedEvaluator.submitTask(taskConfiguration);
                TaskCountingDriver.this.expectedRunningTaskIds.add(taskId);
            }
        }
    }
}

