/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.subcontexts;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.context.ClosedContext;
import org.apache.reef.driver.context.ContextConfiguration;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.subcontexts.ContextStartHandler1;
import org.apache.reef.tests.subcontexts.ContextStartHandler2;
import org.apache.reef.tests.subcontexts.ContextStopHandler1;
import org.apache.reef.tests.subcontexts.ContextStopHandler2;
import org.apache.reef.wake.EventHandler;

@Unit
final class SubContextDriver {
    private static final Logger LOG = Logger.getLogger(SubContextDriver.class.getName());
    private static final String CONTEXT_1_IDENTIFIER = "CONTEXT_1";
    private static final String CONTEXT_2_IDENTIFIER = "CONTEXT_2";
    private State state = State.INIT;

    @Inject
    SubContextDriver() {
    }

    final class ContextClosedHandler
    implements EventHandler<ClosedContext> {
        ContextClosedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(ClosedContext closedContext) {
            LOG.log(Level.FINE, "Received ClosedContext: {0}", closedContext);
            if (closedContext.getId().equals(SubContextDriver.CONTEXT_2_IDENTIFIER)) {
                SubContextDriver subContextDriver = SubContextDriver.this;
                synchronized (subContextDriver) {
                    assert (SubContextDriver.this.state == State.CONTEXT_2_SUBMITTED);
                }
                closedContext.getParentContext().close();
                SubContextDriver.this.state = State.CONTEXT_2_CLOSED;
            } else if (closedContext.getId().equals(SubContextDriver.CONTEXT_1_IDENTIFIER)) {
                SubContextDriver subContextDriver = SubContextDriver.this;
                synchronized (subContextDriver) {
                    assert (SubContextDriver.this.state == State.CONTEXT_2_CLOSED);
                }
                throw new IllegalStateException("Received a closed context for the root context");
            }
        }
    }

    final class ContextActiveHandler
    implements EventHandler<ActiveContext> {
        ContextActiveHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(ActiveContext activeContext) {
            LOG.log(Level.FINE, "Received ActiveContext: {0}", activeContext);
            if (activeContext.getId().equals(SubContextDriver.CONTEXT_1_IDENTIFIER)) {
                SubContextDriver subContextDriver = SubContextDriver.this;
                synchronized (subContextDriver) {
                    assert (SubContextDriver.this.state == State.CONTEXT_1_SUBMITTED);
                }
                LOG.log(Level.FINE, "Submitting sub context");
                Configuration contextConfiguration = ContextConfiguration.CONF.set((Impl)ContextConfiguration.ON_CONTEXT_STARTED, ContextStartHandler2.class).set((Impl)ContextConfiguration.ON_CONTEXT_STOP, ContextStopHandler2.class).set((Param)ContextConfiguration.IDENTIFIER, SubContextDriver.CONTEXT_2_IDENTIFIER).build();
                activeContext.submitContext(contextConfiguration);
                SubContextDriver subContextDriver2 = SubContextDriver.this;
                synchronized (subContextDriver2) {
                    SubContextDriver.this.state = State.CONTEXT_2_SUBMITTED;
                }
            }
            if (activeContext.getId().equals(SubContextDriver.CONTEXT_2_IDENTIFIER)) {
                LOG.log(Level.INFO, "Received sub context. Closing");
                activeContext.close();
            }
        }
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(AllocatedEvaluator allocatedEvaluator) {
            LOG.log(Level.FINE, "Submitting root context");
            try {
                Configuration contextConfiguration = ContextConfiguration.CONF.set((Impl)ContextConfiguration.ON_CONTEXT_STARTED, ContextStartHandler1.class).set((Impl)ContextConfiguration.ON_CONTEXT_STOP, ContextStopHandler1.class).set((Param)ContextConfiguration.IDENTIFIER, SubContextDriver.CONTEXT_1_IDENTIFIER).build();
                allocatedEvaluator.submitContext(contextConfiguration);
                SubContextDriver subContextDriver = SubContextDriver.this;
                synchronized (subContextDriver) {
                    SubContextDriver.this.state = State.CONTEXT_1_SUBMITTED;
                }
            }
            catch (BindException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static enum State {
        INIT,
        CONTEXT_1_SUBMITTED,
        CONTEXT_2_SUBMITTED,
        CONTEXT_2_CLOSED;

    }
}

