/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.roguethread;

import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.client.DriverLauncher;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentFactory;
import org.apache.reef.tests.library.driver.ExpectedTaskFailureHandler;
import org.apache.reef.tests.library.driver.OnDriverStartedAllocateOne;
import org.apache.reef.tests.roguethread.RogueThreadDriver;
import org.apache.reef.util.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class RogueThreadTest {
    private final TestEnvironment testEnvironment = TestEnvironmentFactory.getNewTestEnvironment();

    @Before
    public void setUp() throws Exception {
        this.testEnvironment.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.testEnvironment.tearDown();
    }

    @Test
    public void testRogueThread() throws InjectionException {
        Configuration runtimeConfiguration = this.testEnvironment.getRuntimeConfiguration();
        Configuration driverConfiguration = DriverConfiguration.CONF.set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(this.getClass())).set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "Test_RogueThreadTest").set((Impl)DriverConfiguration.ON_DRIVER_STARTED, OnDriverStartedAllocateOne.class).set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, RogueThreadDriver.EvaluatorAllocationHandler.class).set((Impl)DriverConfiguration.ON_TASK_FAILED, ExpectedTaskFailureHandler.class).build();
        LauncherStatus state = DriverLauncher.getLauncher((Configuration)runtimeConfiguration).run(driverConfiguration, (long)this.testEnvironment.getTestTimeout());
        Assert.assertTrue((String)("Job state after execution: " + state), (boolean)state.isSuccess());
    }
}

