/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.rack.awareness;

import javax.inject.Inject;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.tests.rack.awareness.RackNameParameter;
import org.apache.reef.wake.EventHandler;

@Unit
final class RackAwareEvaluatorTestDriver {
    private final String expectedRackName;

    @Inject
    RackAwareEvaluatorTestDriver(@Parameter(value=RackNameParameter.class) String rackName) {
        this.expectedRackName = rackName;
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        public void onNext(AllocatedEvaluator allocatedEvaluator) {
            String actual = allocatedEvaluator.getEvaluatorDescriptor().getNodeDescriptor().getRackDescriptor().getName();
            if (!RackAwareEvaluatorTestDriver.this.expectedRackName.equals(actual)) {
                throw new DriverSideFailure("The rack received is different that the expected one, received " + actual + " expected " + RackAwareEvaluatorTestDriver.this.expectedRackName);
            }
            allocatedEvaluator.close();
        }
    }
}

