/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.rack.awareness;

import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.client.DriverLauncher;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.runtime.local.client.parameters.RackNames;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.LocalTestEnvironment;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.library.driver.OnDriverStartedAllocateOne;
import org.apache.reef.tests.rack.awareness.OnDriverStartedAllocateOneInRack;
import org.apache.reef.tests.rack.awareness.RackAwareEvaluatorTestDriver;
import org.apache.reef.tests.rack.awareness.RackNameParameter;
import org.apache.reef.util.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class RackAwareEvaluatorTest {
    private static final String RACK1 = "/rack1";
    private final TestEnvironment testEnvironment = new LocalTestEnvironment();

    @Before
    public void setUp() throws Exception {
        this.testEnvironment.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.testEnvironment.tearDown();
    }

    @Test
    public void testRackAwareEvaluatorRunningOnDefaultRack() {
        Configuration driverConfiguration = DriverConfiguration.CONF.set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "TEST_RackAwareEvaluator").set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(RackAwareEvaluatorTestDriver.class)).set((Impl)DriverConfiguration.ON_DRIVER_STARTED, OnDriverStartedAllocateOne.class).set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, RackAwareEvaluatorTestDriver.EvaluatorAllocatedHandler.class).build();
        LauncherStatus status = this.testEnvironment.run(driverConfiguration);
        Assert.assertTrue((String)("Job state after execution: " + status), (boolean)status.isSuccess());
    }

    @Test
    public void testRackAwareEvaluatorRunningOnRack1() throws InjectionException {
        Configuration driverConfiguration = DriverConfiguration.CONF.set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "TEST_RackAwareEvaluator").set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(RackAwareEvaluatorTestDriver.class)).set((Impl)DriverConfiguration.ON_DRIVER_STARTED, OnDriverStartedAllocateOneInRack.class).set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, RackAwareEvaluatorTestDriver.EvaluatorAllocatedHandler.class).build();
        Configuration testDriverConfig = Tang.Factory.getTang().newConfigurationBuilder(new Configuration[]{driverConfiguration}).bindNamedParameter(RackNameParameter.class, RACK1).build();
        Configuration testRuntimeConfig = Tang.Factory.getTang().newConfigurationBuilder(new Configuration[]{this.testEnvironment.getRuntimeConfiguration()}).bindSetEntry(RackNames.class, RACK1).build();
        LauncherStatus status = DriverLauncher.getLauncher((Configuration)testRuntimeConfig).run(testDriverConfig, (long)this.testEnvironment.getTestTimeout());
        Assert.assertTrue((String)("Job state after execution: " + status), (boolean)status.isSuccess());
    }
}

