/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.multipleEventHandlerInstances;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.evaluator.EvaluatorRequest;
import org.apache.reef.driver.evaluator.EvaluatorRequestor;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StartTime;

public final class StartHandler
implements EventHandler<StartTime> {
    private static final Logger LOG = Logger.getLogger(StartHandler.class.getName());
    private static int countInstances = 0;
    private final EvaluatorRequestor requestor;

    @Inject
    public StartHandler(EvaluatorRequestor requestor) {
        this.requestor = requestor;
        if (++countInstances > 1) {
            throw new DriverSideFailure("Expect StartHandler be created only once");
        }
    }

    public void onNext(StartTime startTime) {
        LOG.log(Level.INFO, "StartTime: ", startTime);
        this.requestor.submit(EvaluatorRequest.newBuilder().setNumber(5).setMemory(64).setNumberOfCores(1).build());
    }
}

