/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.multipleEventHandlerInstances;

import java.util.logging.Logger;
import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.client.DriverLauncher;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.runtime.local.client.LocalRuntimeConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.multipleEventHandlerInstances.ActiveContextHandler;
import org.apache.reef.tests.multipleEventHandlerInstances.AllocatedEvaluatorHandler;
import org.apache.reef.tests.multipleEventHandlerInstances.ClosedContextHandler;
import org.apache.reef.tests.multipleEventHandlerInstances.CompletedEvaluatorHandler;
import org.apache.reef.tests.multipleEventHandlerInstances.CompletedTaskHandler;
import org.apache.reef.tests.multipleEventHandlerInstances.RunningTaskHandler;
import org.apache.reef.tests.multipleEventHandlerInstances.StartHandler;
import org.apache.reef.util.EnvironmentUtils;
import org.junit.Assert;
import org.junit.Test;

public class Client {
    private static final Logger LOG = Logger.getLogger(Client.class.getName());
    private static final int JOB_TIMEOUT = 300000;

    public static LauncherStatus runReefJob(Configuration runtimeConf, int timeOut) throws BindException, InjectionException {
        Configuration driverConf = DriverConfiguration.CONF.set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(StartHandler.class)).set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "MultipleHandlerInstances").set((Impl)DriverConfiguration.ON_DRIVER_STARTED, StartHandler.class).set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, AllocatedEvaluatorHandler.class).set((Impl)DriverConfiguration.ON_CONTEXT_ACTIVE, ActiveContextHandler.class).set((Impl)DriverConfiguration.ON_TASK_RUNNING, RunningTaskHandler.class).set((Impl)DriverConfiguration.ON_TASK_COMPLETED, CompletedTaskHandler.class).set((Impl)DriverConfiguration.ON_CONTEXT_CLOSED, ClosedContextHandler.class).set((Impl)DriverConfiguration.ON_EVALUATOR_COMPLETED, CompletedEvaluatorHandler.class).build();
        return DriverLauncher.getLauncher((Configuration)runtimeConf).run(driverConf, (long)timeOut);
    }

    @Test
    public void testMultipleInstances() throws BindException, InjectionException {
        Configuration runtimeConfiguration = LocalRuntimeConfiguration.CONF.set((Param)LocalRuntimeConfiguration.MAX_NUMBER_OF_EVALUATORS, (Number)2).build();
        LauncherStatus status = Client.runReefJob(runtimeConfiguration, 300000);
        Assert.assertTrue((String)("Reef Job MultipleHandlerInstances failed: " + status), (boolean)status.isSuccess());
    }
}

