/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.multipleEventHandlerInstances;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.context.ContextConfiguration;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.wake.EventHandler;

public final class AllocatedEvaluatorHandler
implements EventHandler<AllocatedEvaluator> {
    private static final Logger LOG = Logger.getLogger(AllocatedEvaluatorHandler.class.getName());
    private static int countInstances = 0;

    @Inject
    public AllocatedEvaluatorHandler() {
        if (++countInstances > 1) {
            throw new DriverSideFailure("Expect AllocatedEvaluatorHandler to be created only once");
        }
    }

    public void onNext(AllocatedEvaluator allocatedEvaluator) {
        LOG.log(Level.INFO, "Submitting empty context to AllocatedEvaluator: {0}", allocatedEvaluator);
        try {
            Configuration contextConfiguration = ContextConfiguration.CONF.set((Param)ContextConfiguration.IDENTIFIER, "EmptyREEFContext").build();
            allocatedEvaluator.submitContext(contextConfiguration);
        }
        catch (BindException ex) {
            throw new RuntimeException("Unable to setup Task or Context configuration.", ex);
        }
    }
}

