/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.multipleEventHandlerInstances;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.tests.multipleEventHandlerInstances.EmptyTask;
import org.apache.reef.wake.EventHandler;

public final class ActiveContextHandler
implements EventHandler<ActiveContext> {
    private static final Logger LOG = Logger.getLogger(ActiveContextHandler.class.getName());
    private static int countInstances = 0;

    @Inject
    public ActiveContextHandler() {
        if (++countInstances > 1) {
            throw new DriverSideFailure("Expect ActiveContextHandler to be created only once");
        }
    }

    public void onNext(ActiveContext activeContext) {
        Configuration taskConfiguration;
        LOG.log(Level.FINEST, "ActiveContext received. Submitting empty task to it");
        try {
            taskConfiguration = TaskConfiguration.CONF.set((Param)TaskConfiguration.IDENTIFIER, "EmptyREEFTask").set((Impl)TaskConfiguration.TASK, EmptyTask.class).build();
        }
        catch (BindException e) {
            throw new RuntimeException("Unable to setup Task configuration", e);
        }
        activeContext.submitTask(taskConfiguration);
    }
}

