/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.messaging.task;

import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.client.DriverLauncher;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentFactory;
import org.apache.reef.tests.library.driver.OnDriverStartedAllocateOne;
import org.apache.reef.tests.messaging.task.TaskMessagingDriver;
import org.apache.reef.util.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class TaskMessagingTest {
    private final TestEnvironment testEnvironment = TestEnvironmentFactory.getNewTestEnvironment();

    @Before
    public void setUp() throws Exception {
        this.testEnvironment.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.testEnvironment.tearDown();
    }

    @Test
    public void testTaskMsg() throws BindException, InjectionException {
        Configuration runtimeConfiguration = this.testEnvironment.getRuntimeConfiguration();
        Configuration driverConfig = DriverConfiguration.CONF.set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(this.getClass())).set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "DriverTaskMsg").set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, TaskMessagingDriver.EvaluatorAllocatedHandler.class).set((Impl)DriverConfiguration.ON_TASK_RUNNING, TaskMessagingDriver.TaskRunningHandler.class).set((Impl)DriverConfiguration.ON_TASK_MESSAGE, TaskMessagingDriver.TaskMessageHandler.class).set((Impl)DriverConfiguration.ON_DRIVER_STARTED, OnDriverStartedAllocateOne.class).build();
        LauncherStatus status = DriverLauncher.getLauncher((Configuration)runtimeConfiguration).run(driverConfig, (long)this.testEnvironment.getTestTimeout());
        Assert.assertEquals((Object)LauncherStatus.COMPLETED, (Object)status);
    }
}

