/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.files;

import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.task.Task;
import org.apache.reef.tests.files.FileResourceTestTaskConfiguration;
import org.apache.reef.tests.library.exceptions.TaskSideFailure;
import org.apache.reef.wake.time.Clock;

final class FileResourceTestTask
implements Task {
    private static final Logger LOG = Logger.getLogger(FileResourceTestTask.class.getName());
    private final Set<String> expectedFileNames;
    private final Clock clock;
    private final File localFolder;

    @Inject
    FileResourceTestTask(@Parameter(value=FileResourceTestTaskConfiguration.FileNamesToExpect.class) Set<String> expectedFileNames, Clock clock, REEFFileNames fileNames) {
        this.expectedFileNames = expectedFileNames;
        this.clock = clock;
        this.localFolder = fileNames.getLocalFolder();
    }

    public byte[] call(byte[] memento) throws Exception {
        for (String fileName : this.expectedFileNames) {
            File file = new File(this.localFolder, fileName);
            LOG.log(Level.INFO, "Testing file: " + file.getAbsolutePath());
            if (!file.exists()) {
                throw new TaskSideFailure("Cannot find file: " + fileName);
            }
            if (!file.isFile()) {
                throw new TaskSideFailure("Not a file: " + fileName);
            }
            if (file.canRead()) continue;
            throw new TaskSideFailure("Can't read: " + fileName);
        }
        return new byte[0];
    }
}

