/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.files;

import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.EvaluatorRequest;
import org.apache.reef.driver.evaluator.EvaluatorRequestor;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Configurations;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.formats.ConfigurationModule;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.files.FileResourceTestDriverConfiguration;
import org.apache.reef.tests.files.FileResourceTestTask;
import org.apache.reef.tests.files.FileResourceTestTaskConfiguration;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StartTime;

@Unit
final class FileResourceTestDriver {
    private static final Logger LOG = Logger.getLogger(FileResourceTestDriver.class.getName());
    private final Set<String> fileNamesToExpect;
    private final EvaluatorRequestor requestor;
    private final REEFFileNames fileNames;
    private final File localFolder;

    @Inject
    public FileResourceTestDriver(@Parameter(value=FileResourceTestDriverConfiguration.FileNamesToExpect.class) Set<String> fileNamesToExpect, EvaluatorRequestor requestor, REEFFileNames fileNames) {
        this.fileNamesToExpect = fileNamesToExpect;
        this.requestor = requestor;
        this.fileNames = fileNames;
        this.localFolder = fileNames.getLocalFolder();
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        public void onNext(AllocatedEvaluator allocatedEvaluator) {
            try {
                for (String fileName : FileResourceTestDriver.this.fileNamesToExpect) {
                    allocatedEvaluator.addFile(new File(FileResourceTestDriver.this.localFolder, fileName));
                }
                Configuration taskConfiguration = TaskConfiguration.CONF.set((Param)TaskConfiguration.IDENTIFIER, "TestTask").set((Impl)TaskConfiguration.TASK, FileResourceTestTask.class).build();
                ConfigurationModule testTaskConfigurationModule = FileResourceTestTaskConfiguration.CONF;
                for (String fileName : FileResourceTestDriver.this.fileNamesToExpect) {
                    testTaskConfigurationModule = testTaskConfigurationModule.set(FileResourceTestTaskConfiguration.EXPECTED_FILE_NAME, fileName);
                }
                Configuration finalTaskConfiguration = Configurations.merge((Configuration[])new Configuration[]{taskConfiguration, testTaskConfigurationModule.build()});
                allocatedEvaluator.submitTask(finalTaskConfiguration);
            }
            catch (Exception e) {
                throw new DriverSideFailure("Unable to submit context and task", (Throwable)e);
            }
        }
    }

    final class StartHandler
    implements EventHandler<StartTime> {
        StartHandler() {
        }

        public void onNext(StartTime startTime) {
            LOG.log(Level.INFO, "StartTime: {0} Number of files in the set: {1}", new Object[]{startTime, FileResourceTestDriver.this.fileNamesToExpect.size()});
            for (String fileName : FileResourceTestDriver.this.fileNamesToExpect) {
                File file = new File(FileResourceTestDriver.this.localFolder, fileName);
                LOG.log(Level.INFO, "Testing file: " + file.getAbsolutePath());
                if (!file.exists()) {
                    throw new DriverSideFailure("Cannot find file: " + fileName);
                }
                if (!file.isFile()) {
                    throw new DriverSideFailure("Not a file: " + fileName);
                }
                if (file.canRead()) continue;
                throw new DriverSideFailure("Can't read: " + fileName);
            }
            FileResourceTestDriver.this.requestor.submit(EvaluatorRequest.newBuilder().setNumber(1).setMemory(64).setNumberOfCores(1).build());
        }
    }
}

