/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.files;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.client.DriverLauncher;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.io.TempFileCreator;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Configurations;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.ConfigurationModule;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentFactory;
import org.apache.reef.tests.files.FileResourceTestDriver;
import org.apache.reef.tests.files.FileResourceTestDriverConfiguration;
import org.apache.reef.util.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class FileResourceTest {
    private static final Logger LOG = Logger.getLogger(FileResourceTest.class.getName());
    private final TestEnvironment testEnvironment = TestEnvironmentFactory.getNewTestEnvironment();
    private final int nFiles = 3;

    private static Configuration getDriverConfiguration(Set<File> theFiles) throws BindException {
        ConfigurationModule driverConfigurationModule = DriverConfiguration.CONF.set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(FileResourceTestDriver.class)).set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "TEST_FileResourceTest").set((Impl)DriverConfiguration.ON_DRIVER_STARTED, FileResourceTestDriver.StartHandler.class).set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, FileResourceTestDriver.EvaluatorAllocatedHandler.class);
        for (File f : theFiles) {
            LOG.log(Level.FINEST, "Adding a file to the DriverConfiguration: " + f.getAbsolutePath());
            driverConfigurationModule = driverConfigurationModule.set((Param)DriverConfiguration.LOCAL_FILES, f.getAbsolutePath());
        }
        return driverConfigurationModule.build();
    }

    private static Configuration getTestDriverConfiguration(Set<File> theFiles) throws BindException, IOException {
        ConfigurationModule testDriverConfigurationModule = FileResourceTestDriverConfiguration.CONF;
        for (File f : theFiles) {
            LOG.log(Level.FINEST, "Adding a file to the TestDriverConfiguration: " + f.getName());
            testDriverConfigurationModule = testDriverConfigurationModule.set(FileResourceTestDriverConfiguration.EXPECTED_FILE_NAME, f.getName());
        }
        Configuration testDriverConfiguration = testDriverConfigurationModule.build();
        return testDriverConfiguration;
    }

    private Set<File> getTempFiles(int n) throws IOException, InjectionException {
        TempFileCreator tempFileCreator = (TempFileCreator)Tang.Factory.getTang().newInjector(this.testEnvironment.getRuntimeConfiguration()).getInstance(TempFileCreator.class);
        HashSet<File> theFiles = new HashSet<File>();
        for (int i = 0; i < n; ++i) {
            File tempFile = tempFileCreator.createTempFile("REEF_TEST_", ".tmp");
            tempFile.deleteOnExit();
            theFiles.add(tempFile);
        }
        return theFiles;
    }

    @Before
    public void setUp() throws Exception {
        this.testEnvironment.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.testEnvironment.tearDown();
    }

    @Test
    public void testDriverFiles() throws IOException, BindException, InjectionException {
        Set<File> theFiles = this.getTempFiles(this.nFiles);
        Configuration finalDriverConfiguration = Configurations.merge((Configuration[])new Configuration[]{FileResourceTest.getDriverConfiguration(theFiles), FileResourceTest.getTestDriverConfiguration(theFiles)});
        LauncherStatus status = DriverLauncher.getLauncher((Configuration)this.testEnvironment.getRuntimeConfiguration()).run(finalDriverConfiguration, (long)this.testEnvironment.getTestTimeout());
        Assert.assertTrue((String)("Job state after execution: " + status), (boolean)status.isSuccess());
    }
}

