/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.fail;

import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.task.Task;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentFactory;
import org.apache.reef.tests.TestUtils;
import org.apache.reef.tests.fail.task.Client;
import org.apache.reef.tests.fail.task.FailTask;
import org.apache.reef.tests.fail.task.FailTaskCall;
import org.apache.reef.tests.fail.task.FailTaskClose;
import org.apache.reef.tests.fail.task.FailTaskMsg;
import org.apache.reef.tests.fail.task.FailTaskStart;
import org.apache.reef.tests.fail.task.FailTaskStop;
import org.apache.reef.tests.fail.task.FailTaskSuspend;
import org.apache.reef.tests.library.exceptions.SimulatedTaskFailure;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class FailTaskTest {
    private final TestEnvironment testEnvironment = TestEnvironmentFactory.getNewTestEnvironment();

    @Before
    public void setUp() throws Exception {
        this.testEnvironment.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.testEnvironment.tearDown();
    }

    private void failOn(Class<? extends Task> failTaskClass) throws BindException, InjectionException {
        TestUtils.assertLauncherFailure(Client.run(failTaskClass, (Configuration)this.testEnvironment.getRuntimeConfiguration(), (int)this.testEnvironment.getTestTimeout()), SimulatedTaskFailure.class);
    }

    @Test
    public void testFailTask() throws BindException, InjectionException {
        this.failOn(FailTask.class);
    }

    @Test
    public void testFailTaskCall() throws BindException, InjectionException {
        this.failOn(FailTaskCall.class);
    }

    @Test
    public void testFailTaskMsg() throws BindException, InjectionException {
        this.failOn(FailTaskMsg.class);
    }

    @Test
    public void testFailTaskSuspend() throws BindException, InjectionException {
        this.failOn(FailTaskSuspend.class);
    }

    @Test
    public void testFailTaskStart() throws BindException, InjectionException {
        this.failOn(FailTaskStart.class);
    }

    @Test
    public void testFailTaskStop() throws BindException, InjectionException {
        this.failOn(FailTaskStop.class);
    }

    @Test
    public void testFailTaskClose() throws BindException, InjectionException {
        this.failOn(FailTaskClose.class);
    }
}

