/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.fail;

import org.apache.reef.client.LauncherStatus;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.CompletedEvaluator;
import org.apache.reef.driver.task.CompletedTask;
import org.apache.reef.driver.task.RunningTask;
import org.apache.reef.driver.task.SuspendedTask;
import org.apache.reef.driver.task.TaskMessage;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentFactory;
import org.apache.reef.tests.TestUtils;
import org.apache.reef.tests.fail.driver.FailClient;
import org.apache.reef.tests.fail.driver.FailDriver;
import org.apache.reef.tests.library.exceptions.SimulatedDriverFailure;
import org.apache.reef.wake.time.event.Alarm;
import org.apache.reef.wake.time.event.StartTime;
import org.apache.reef.wake.time.event.StopTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FailDriverTest {
    private final TestEnvironment testEnvironment = TestEnvironmentFactory.getNewTestEnvironment();

    @Before
    public void setUp() throws Exception {
        this.testEnvironment.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.testEnvironment.tearDown();
    }

    private void failOn(Class<?> clazz) throws BindException, InjectionException {
        TestUtils.assertLauncherFailure(FailClient.run(clazz, (Configuration)this.testEnvironment.getRuntimeConfiguration(), (int)this.testEnvironment.getTestTimeout()), SimulatedDriverFailure.class);
    }

    @Test
    public void testFailDriverConstructor() throws BindException, InjectionException {
        this.failOn(FailDriver.class);
    }

    @Test
    public void testFailDriverStart() throws BindException, InjectionException {
        this.failOn(StartTime.class);
    }

    @Test
    public void testFailDriverAllocatedEvaluator() throws BindException, InjectionException {
        this.failOn(AllocatedEvaluator.class);
    }

    @Test
    public void testFailDriverActiveContext() throws BindException, InjectionException {
        this.failOn(ActiveContext.class);
    }

    @Test
    public void testFailDriverRunningTask() throws BindException, InjectionException {
        this.failOn(RunningTask.class);
    }

    @Test
    public void testFailDriverTaskMessage() throws BindException, InjectionException {
        this.failOn(TaskMessage.class);
    }

    @Test
    public void testFailDriverSuspendedTask() throws BindException, InjectionException {
        this.failOn(SuspendedTask.class);
    }

    @Test
    public void testFailDriverCompletedTask() throws BindException, InjectionException {
        this.failOn(CompletedTask.class);
    }

    @Test
    public void testFailDriverCompletedEvaluator() throws BindException, InjectionException {
        this.failOn(CompletedEvaluator.class);
    }

    @Test
    public void testFailDriverAlarm() throws BindException, InjectionException {
        this.failOn(Alarm.class);
    }

    @Test
    public void testFailDriverStop() throws BindException, InjectionException {
        this.failOn(StopTime.class);
    }

    @Test
    public void testDriverCompleted() throws BindException, InjectionException {
        Configuration runtimeConfiguration = this.testEnvironment.getRuntimeConfiguration();
        LauncherStatus status = FailClient.run(FailDriverTest.class, (Configuration)runtimeConfiguration, (int)this.testEnvironment.getTestTimeout());
        Assert.assertEquals((Object)LauncherStatus.COMPLETED, (Object)status);
    }
}

