/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.fail;

import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestDriverLauncher;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentFactory;
import org.apache.reef.tests.TestUtils;
import org.apache.reef.tests.fail.driver.DriverFailOnFail;
import org.apache.reef.tests.library.exceptions.SimulatedDriverFailure;
import org.apache.reef.util.EnvironmentUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class DriverFailOnFailTest {
    private final TestEnvironment testEnvironment = TestEnvironmentFactory.getNewTestEnvironment();

    @Before
    public void setUp() throws Exception {
        this.testEnvironment.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.testEnvironment.tearDown();
    }

    @Test
    public void testDriverFailOnFail() throws BindException, InjectionException {
        Configuration runtimeConfiguration = this.testEnvironment.getRuntimeConfiguration();
        Configuration driverConfig = DriverConfiguration.CONF.set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(this.getClass())).set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "Fail2").set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, DriverFailOnFail.AllocatedEvaluatorHandler.class).set((Impl)DriverConfiguration.ON_TASK_FAILED, DriverFailOnFail.FailedTaskHandler.class).set((Impl)DriverConfiguration.ON_DRIVER_STARTED, DriverFailOnFail.StartHandler.class).build();
        TestUtils.assertLauncherFailure(TestDriverLauncher.getLauncher((Configuration)runtimeConfiguration).run(driverConfig, (long)this.testEnvironment.getTestTimeout()), SimulatedDriverFailure.class);
    }
}

