/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.evaluatorsize;

import javax.inject.Inject;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.task.Task;
import org.apache.reef.tests.evaluatorsize.EvaluatorSizeTestConfiguration;
import org.apache.reef.tests.library.exceptions.TaskSideFailure;

final class MemorySizeTask
implements Task {
    private static final int MEGA = 0x100000;
    private static final int ALLOWED_DELTA = 128;
    private final int memorySize;

    @Inject
    public MemorySizeTask(@Parameter(value=EvaluatorSizeTestConfiguration.MemorySize.class) int memorySize) {
        this.memorySize = memorySize;
    }

    public byte[] call(byte[] memento) throws Exception {
        long maxHeapSizeInBytes = Runtime.getRuntime().maxMemory();
        long maxHeapSizeMB = maxHeapSizeInBytes / 0x100000L;
        if (maxHeapSizeMB < (long)(this.memorySize - 128)) {
            throw new TaskSideFailure("Got an Evaluator with too little RAM. Asked for " + this.memorySize + "MB, but got " + maxHeapSizeMB + "MB.");
        }
        return new byte[0];
    }
}

