/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.evaluatorsize;

import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.EvaluatorRequest;
import org.apache.reef.driver.evaluator.EvaluatorRequestor;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.evaluatorsize.EvaluatorSizeTestConfiguration;
import org.apache.reef.tests.evaluatorsize.MemorySizeTask;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StartTime;

@Unit
final class EvaluatorSizeTestDriver {
    private static final Logger LOG = Logger.getLogger(EvaluatorSizeTestDriver.class.getName());
    private final EvaluatorRequestor evaluatorRequestor;
    private final int memorySize;

    @Inject
    public EvaluatorSizeTestDriver(EvaluatorRequestor evaluatorRequestor, @Parameter(value=EvaluatorSizeTestConfiguration.MemorySize.class) int memorySize) {
        this.evaluatorRequestor = evaluatorRequestor;
        this.memorySize = memorySize;
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        public void onNext(AllocatedEvaluator allocatedEvaluator) {
            int evaluatorMemory = allocatedEvaluator.getEvaluatorDescriptor().getMemory();
            if (evaluatorMemory < EvaluatorSizeTestDriver.this.memorySize) {
                throw new DriverSideFailure("Got an Evaluator with too little RAM. Asked for " + EvaluatorSizeTestDriver.this.memorySize + "MB, but got " + evaluatorMemory + "MB.");
            }
            try {
                Configuration taskConfiguration = TaskConfiguration.CONF.set((Impl)TaskConfiguration.TASK, MemorySizeTask.class).set((Param)TaskConfiguration.IDENTIFIER, "EvaluatorSizeTestTask").build();
                Configuration testConfiguration = EvaluatorSizeTestConfiguration.CONF.set(EvaluatorSizeTestConfiguration.MEMORY_SIZE, (Number)EvaluatorSizeTestDriver.this.memorySize).build();
                Configuration mergedTaskConfiguration = Tang.Factory.getTang().newConfigurationBuilder(new Configuration[]{taskConfiguration, testConfiguration}).build();
                allocatedEvaluator.submitTask(mergedTaskConfiguration);
            }
            catch (BindException e) {
                throw new DriverSideFailure("Unable to launch Task", (Throwable)e);
            }
        }
    }

    final class StartHandler
    implements EventHandler<StartTime> {
        StartHandler() {
        }

        public void onNext(StartTime startTime) {
            EvaluatorSizeTestDriver.this.evaluatorRequestor.submit(EvaluatorRequest.newBuilder().setNumber(1).setMemory(EvaluatorSizeTestDriver.this.memorySize).setNumberOfCores(1).build());
        }
    }
}

