/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.evaluatorsize;

import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.client.DriverLauncher;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentFactory;
import org.apache.reef.tests.evaluatorsize.EvaluatorSizeTestConfiguration;
import org.apache.reef.tests.evaluatorsize.EvaluatorSizeTestDriver;
import org.apache.reef.util.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EvaluatorSizeTest {
    private final TestEnvironment testEnvironment = TestEnvironmentFactory.getNewTestEnvironment();

    @Before
    public void setUp() throws Exception {
        this.testEnvironment.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.testEnvironment.tearDown();
    }

    private LauncherStatus runEvaluatorSizeTest(int megaBytes) throws BindException, InjectionException {
        Configuration runtimeConfiguration = this.testEnvironment.getRuntimeConfiguration();
        Configuration testConfiguration = EvaluatorSizeTestConfiguration.CONF.set(EvaluatorSizeTestConfiguration.MEMORY_SIZE, (Number)777).build();
        Configuration driverConfiguration = DriverConfiguration.CONF.set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(this.getClass())).set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "TEST_EvaluatorSizeTest-" + megaBytes).set((Impl)DriverConfiguration.ON_DRIVER_STARTED, EvaluatorSizeTestDriver.StartHandler.class).set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, EvaluatorSizeTestDriver.EvaluatorAllocatedHandler.class).build();
        Configuration mergedDriverConfiguration = Tang.Factory.getTang().newConfigurationBuilder(new Configuration[]{driverConfiguration, testConfiguration}).build();
        LauncherStatus state = DriverLauncher.getLauncher((Configuration)runtimeConfiguration).run(mergedDriverConfiguration, (long)this.testEnvironment.getTestTimeout());
        return state;
    }

    @Test
    public void testEvaluatorSize() throws BindException, InjectionException {
        LauncherStatus state = this.runEvaluatorSizeTest(777);
        Assert.assertTrue((String)("Job state after execution: " + state), (boolean)state.isSuccess());
    }
}

