/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.evaluatorreuse;

import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.client.DriverLauncher;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentFactory;
import org.apache.reef.tests.evaluatorreuse.EvaluatorReuseTestDriver;
import org.apache.reef.tests.library.driver.OnDriverStartedAllocateOne;
import org.apache.reef.util.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EvaluatorReuseTest {
    private final TestEnvironment testEnvironment = TestEnvironmentFactory.getNewTestEnvironment();

    @Before
    public void setUp() throws Exception {
        this.testEnvironment.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.testEnvironment.tearDown();
    }

    @Test
    public void testEvaluatorReuse() throws BindException, InjectionException {
        Configuration runtimeConfiguration = this.testEnvironment.getRuntimeConfiguration();
        Configuration driverConfiguration = DriverConfiguration.CONF.set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(EvaluatorReuseTestDriver.class)).set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "TEST_EvaluatorReuseTest").set((Impl)DriverConfiguration.ON_DRIVER_STARTED, OnDriverStartedAllocateOne.class).set((Impl)DriverConfiguration.ON_TASK_COMPLETED, EvaluatorReuseTestDriver.TaskCompletedHandler.class).set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, EvaluatorReuseTestDriver.EvaluatorAllocatedHandler.class).set((Impl)DriverConfiguration.ON_CONTEXT_ACTIVE, EvaluatorReuseTestDriver.ContextActiveHandler.class).build();
        LauncherStatus status = DriverLauncher.getLauncher((Configuration)runtimeConfiguration).run(driverConfiguration, (long)this.testEnvironment.getTestTimeout());
        Assert.assertTrue((String)("EvaluatorReuse state = " + status), (boolean)status.isSuccess());
    }
}

