/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.evaluatorfailure;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.context.ContextConfiguration;
import org.apache.reef.driver.context.FailedContext;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.FailedEvaluator;
import org.apache.reef.driver.task.FailedTask;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestUtils;
import org.apache.reef.tests.evaluatorfailure.ExpectedException;
import org.apache.reef.tests.evaluatorfailure.FailureSchedulingContextStartHandler;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StopTime;

@Unit
final class EvaluatorFailureDuringAlarmDriver {
    private static final Logger LOG = Logger.getLogger(EvaluatorFailureDuringAlarmDriver.class.getName());
    private final AtomicBoolean failedEvaluatorReceived = new AtomicBoolean(false);
    private final AtomicBoolean otherFailuresReceived = new AtomicBoolean(false);

    @Inject
    EvaluatorFailureDuringAlarmDriver() {
    }

    final class StopHandler
    implements EventHandler<StopTime> {
        StopHandler() {
        }

        public void onNext(StopTime stopTime) {
            if (!EvaluatorFailureDuringAlarmDriver.this.failedEvaluatorReceived.get()) {
                throw new DriverSideFailure("Never Received the FailedEvaluator.");
            }
            LOG.log(Level.FINEST, "Received FailedEvaluator.");
            if (EvaluatorFailureDuringAlarmDriver.this.otherFailuresReceived.get()) {
                throw new DriverSideFailure("Received more events than the FailedEvaluator.");
            }
        }
    }

    final class TaskFailureHandler
    implements EventHandler<FailedTask> {
        TaskFailureHandler() {
        }

        public void onNext(FailedTask failedTask) {
            LOG.log(Level.SEVERE, "Received FailedTask: {0}", failedTask);
            EvaluatorFailureDuringAlarmDriver.this.otherFailuresReceived.set(true);
        }
    }

    final class ContextFailureHandler
    implements EventHandler<FailedContext> {
        ContextFailureHandler() {
        }

        public void onNext(FailedContext failedContext) {
            LOG.log(Level.SEVERE, "Received FailedContext: {0}", failedContext);
            EvaluatorFailureDuringAlarmDriver.this.otherFailuresReceived.set(true);
        }
    }

    final class EvaluatorFailureHandler
    implements EventHandler<FailedEvaluator> {
        EvaluatorFailureHandler() {
        }

        public void onNext(FailedEvaluator failedEvaluator) {
            if (!TestUtils.hasCause((Throwable)failedEvaluator.getEvaluatorException(), ExpectedException.class)) {
                throw new DriverSideFailure("Received an unexpected exception", (Throwable)failedEvaluator.getEvaluatorException());
            }
            EvaluatorFailureDuringAlarmDriver.this.failedEvaluatorReceived.set(true);
            LOG.log(Level.FINEST, "Received an expected exception. All good.");
        }
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        public void onNext(AllocatedEvaluator allocatedEvaluator) {
            Configuration contextConfiguration = ContextConfiguration.CONF.set((Param)ContextConfiguration.IDENTIFIER, "FailingEvaluator").set((Impl)ContextConfiguration.ON_CONTEXT_STARTED, FailureSchedulingContextStartHandler.class).build();
            allocatedEvaluator.submitContext(contextConfiguration);
        }
    }
}

