/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.evaluatorexit;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.FailedEvaluator;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.evaluatorexit.EvaluatorExitTestTask;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StopTime;

@Unit
final class EvaluatorExitTestDriver {
    private static final Logger LOG = Logger.getLogger(EvaluatorExitTestDriver.class.getName());
    private final AtomicBoolean failedEvaluatorReceived = new AtomicBoolean(false);

    @Inject
    EvaluatorExitTestDriver() {
    }

    final class StopHandler
    implements EventHandler<StopTime> {
        StopHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(StopTime stopTime) {
            AtomicBoolean atomicBoolean = EvaluatorExitTestDriver.this.failedEvaluatorReceived;
            synchronized (atomicBoolean) {
                if (!EvaluatorExitTestDriver.this.failedEvaluatorReceived.get()) {
                    throw new DriverSideFailure("Did not receive an expected FailedEvaluator.");
                }
                LOG.log(Level.FINE, "Received an expected FailedEvaluator before exit. All good.");
            }
        }
    }

    final class EvaluatorFailureHandler
    implements EventHandler<FailedEvaluator> {
        EvaluatorFailureHandler() {
        }

        public void onNext(FailedEvaluator failedEvaluator) {
            LOG.log(Level.FINEST, "Received a FailedEvaluator for Evaluator {0}", failedEvaluator.getId());
            EvaluatorExitTestDriver.this.failedEvaluatorReceived.set(true);
        }
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        public void onNext(AllocatedEvaluator allocatedEvaluator) {
            Configuration taskConfiguration = TaskConfiguration.CONF.set((Param)TaskConfiguration.IDENTIFIER, "EvaluatorExitTestTask").set((Impl)TaskConfiguration.TASK, EvaluatorExitTestTask.class).build();
            allocatedEvaluator.submitTask(taskConfiguration);
        }
    }
}

