/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.evaluatorexit;

import java.util.logging.Logger;
import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentFactory;
import org.apache.reef.tests.evaluatorexit.EvaluatorExitTestDriver;
import org.apache.reef.tests.library.driver.OnDriverStartedAllocateOne;
import org.apache.reef.util.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class EvaluatorExitTest {
    private static final Logger LOG = Logger.getLogger(EvaluatorExitTest.class.getName());
    private final TestEnvironment testEnvironment = TestEnvironmentFactory.getNewTestEnvironment();

    @Before
    public void setUp() throws Exception {
        this.testEnvironment.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.testEnvironment.tearDown();
    }

    @Test
    public void testEvaluatorExit() {
        Configuration driverConfiguration = DriverConfiguration.CONF.set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "TEST_EvaluatorExit").set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(EvaluatorExitTestDriver.class)).set((Impl)DriverConfiguration.ON_DRIVER_STARTED, OnDriverStartedAllocateOne.class).set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, EvaluatorExitTestDriver.EvaluatorAllocatedHandler.class).set((Impl)DriverConfiguration.ON_EVALUATOR_FAILED, EvaluatorExitTestDriver.EvaluatorFailureHandler.class).set((Impl)DriverConfiguration.ON_DRIVER_STOP, EvaluatorExitTestDriver.StopHandler.class).build();
        LauncherStatus status = this.testEnvironment.run(driverConfiguration);
        Assert.assertTrue((String)("Job state after execution: " + status), (boolean)status.isSuccess());
    }
}

