/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.configurationproviders;

import javax.inject.Inject;
import org.apache.reef.tang.Injector;
import org.apache.reef.tang.annotations.Name;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.task.Task;
import org.apache.reef.tests.configurationproviders.parameters.DriverAndEvaluatorParameter;
import org.apache.reef.tests.configurationproviders.parameters.EvaluatorParameter;
import org.apache.reef.tests.library.exceptions.TaskSideFailure;

final class ConfigurationProviderTestTask
implements Task {
    private final Injector injector;

    @Inject
    private ConfigurationProviderTestTask(Injector injector) {
        this.injector = injector;
    }

    public byte[] call(byte[] memento) throws Exception {
        this.checkParameter(EvaluatorParameter.class, "This is a parameter only to be bound in the Evaluator config");
        this.checkParameter(DriverAndEvaluatorParameter.class, "This is a parameter to be bound in the Driver and Evaluator config");
        return new byte[0];
    }

    private void checkParameter(Class<? extends Name<String>> name, String expectedValue) {
        try {
            String value = (String)this.injector.getNamedInstance(name);
            if (!expectedValue.equals(value)) {
                throw new TaskSideFailure(name.toString() + " not set correctly");
            }
        }
        catch (InjectionException e) {
            throw new TaskSideFailure(name.toString() + " not set.", (Throwable)e);
        }
    }
}

