/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.configurationproviders;

import javax.inject.Inject;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.EvaluatorRequest;
import org.apache.reef.driver.evaluator.EvaluatorRequestor;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.tang.Injector;
import org.apache.reef.tang.annotations.Name;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.configurationproviders.ConfigurationProviderTestTask;
import org.apache.reef.tests.configurationproviders.parameters.DriverAndEvaluatorParameter;
import org.apache.reef.tests.configurationproviders.parameters.DriverParameter;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StartTime;

@Unit
final class ConfigurationProviderTestDriver {
    private final EvaluatorRequestor evaluatorRequestor;
    private final Injector injector;

    @Inject
    private ConfigurationProviderTestDriver(EvaluatorRequestor evaluatorRequestor, Injector injector) {
        this.evaluatorRequestor = evaluatorRequestor;
        this.injector = injector;
    }

    private void checkParameter(Class<? extends Name<String>> name, String expectedValue) {
        try {
            String value = (String)this.injector.getNamedInstance(name);
            if (!expectedValue.equals(value)) {
                throw new DriverSideFailure(name.toString() + " not set correctly");
            }
        }
        catch (InjectionException e) {
            throw new DriverSideFailure(name.toString() + " not set.", (Throwable)e);
        }
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        public void onNext(AllocatedEvaluator allocatedEvaluator) {
            allocatedEvaluator.submitTask(TaskConfiguration.CONF.set((Impl)TaskConfiguration.TASK, ConfigurationProviderTestTask.class).set((Param)TaskConfiguration.IDENTIFIER, "ConfigurationProviderTestTask").build());
        }
    }

    final class StartHandler
    implements EventHandler<StartTime> {
        StartHandler() {
        }

        public void onNext(StartTime startTime) {
            ConfigurationProviderTestDriver.this.checkParameter(DriverParameter.class, "This is a parameter only to be bound in the Driver config.");
            ConfigurationProviderTestDriver.this.checkParameter(DriverAndEvaluatorParameter.class, "This is a parameter to be bound in the Driver and Evaluator config");
            ConfigurationProviderTestDriver.this.evaluatorRequestor.submit(EvaluatorRequest.newBuilder().setNumber(1).setMemory(32).build());
        }
    }
}

