/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.configurationproviders;

import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.client.DriverLauncher;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.client.parameters.DriverConfigurationProviders;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentFactory;
import org.apache.reef.tests.configurationproviders.ConfigurationProviderTestDriver;
import org.apache.reef.tests.configurationproviders.TestDriverConfigurationProvider;
import org.apache.reef.util.EnvironmentUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ConfigurationProviderTest {
    private final TestEnvironment testEnvironment = TestEnvironmentFactory.getNewTestEnvironment();

    private Configuration getRuntimeConfiguration() {
        return Tang.Factory.getTang().newConfigurationBuilder(new Configuration[]{this.testEnvironment.getRuntimeConfiguration()}).bindSetEntry(DriverConfigurationProviders.class, TestDriverConfigurationProvider.class).build();
    }

    private Configuration getDriverConfiguration() {
        return DriverConfiguration.CONF.set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "ConfigurationProviderTest").set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(ConfigurationProviderTestDriver.class)).set((Impl)DriverConfiguration.ON_DRIVER_STARTED, ConfigurationProviderTestDriver.StartHandler.class).set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, ConfigurationProviderTestDriver.EvaluatorAllocatedHandler.class).build();
    }

    @Before
    public void setUp() throws Exception {
        this.testEnvironment.setUp();
    }

    @Test
    public void testConfigurationProviders() throws InjectionException {
        LauncherStatus status = DriverLauncher.getLauncher((Configuration)this.getRuntimeConfiguration()).run(this.getDriverConfiguration(), (long)this.testEnvironment.getTestTimeout());
        Assert.assertTrue((String)("ConfigurationProviderTest completed with status: " + status), (boolean)status.isSuccess());
    }
}

