/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.close_eval;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.EvaluatorRequest;
import org.apache.reef.driver.evaluator.EvaluatorRequestor;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StartTime;

@Unit
final class CloseEvaluatorDriver {
    private static final Logger LOG = Logger.getLogger(CloseEvaluatorDriver.class.getName());
    private static final int NUM_EVALUATORS = 16;
    private final EvaluatorRequestor requestor;

    @Inject
    CloseEvaluatorDriver(EvaluatorRequestor requestor) {
        this.requestor = requestor;
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        public void onNext(AllocatedEvaluator eval) {
            LOG.log(Level.FINE, "Allocated Evaluator: {0} :: closing", eval);
            eval.close();
        }
    }

    final class StartHandler
    implements EventHandler<StartTime> {
        StartHandler() {
        }

        public void onNext(StartTime time) {
            LOG.log(Level.FINE, "StartTime: {0} :: request {1} evaluators", new Object[]{time, 16});
            CloseEvaluatorDriver.this.requestor.submit(EvaluatorRequest.newBuilder().setNumber(16).setMemory(256).setNumberOfCores(1).build());
        }
    }
}

