/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.client.LauncherStatus;
import org.junit.Assert;

public final class TestUtils {
    private static final Logger LOG = Logger.getLogger(TestUtils.class.getName());

    public static void assertLauncherFailure(LauncherStatus status, Class<? extends Throwable> clazz) {
        Assert.assertEquals((Object)LauncherStatus.FAILED, (Object)status);
        Throwable ex = (Throwable)status.getError().orElse(null);
        if (!TestUtils.hasCause(ex, clazz)) {
            LOG.log(Level.WARNING, "Unexpected Error: " + status, (Throwable)status.getError().get());
            Assert.fail((String)("Unexpected error: " + status.getError().orElse(null)));
        }
    }

    public static boolean hasCause(Throwable ex, Class<? extends Throwable> clazz) {
        for (Throwable exception = ex; exception != null; exception = exception.getCause()) {
            if (!clazz.isInstance(exception)) continue;
            return true;
        }
        return false;
    }

    private TestUtils() {
    }
}

