/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.tests.LocalTestEnvironment;
import org.apache.reef.tests.MesosTestEnvironment;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.YarnTestEnvironment;

public final class TestEnvironmentFactory {
    private static final Logger LOG = Logger.getLogger(TestEnvironmentFactory.class.getName());

    public static TestEnvironment getNewTestEnvironment() {
        boolean isYarn = Boolean.parseBoolean(System.getenv("REEF_TEST_YARN"));
        boolean isMesos = Boolean.parseBoolean(System.getenv("REEF_TEST_MESOS"));
        if (isYarn && isMesos) {
            throw new RuntimeException("Cannot test on two runtimes at once");
        }
        if (isYarn) {
            LOG.log(Level.INFO, "Running tests on YARN");
            return new YarnTestEnvironment();
        }
        if (isMesos) {
            LOG.log(Level.INFO, "Running tests on Mesos");
            return new MesosTestEnvironment();
        }
        LOG.log(Level.INFO, "Running tests on Local");
        return new LocalTestEnvironment();
    }

    private TestEnvironmentFactory() {
    }
}

