/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests;

import org.apache.reef.runtime.mesos.client.MesosClientConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentBase;

public final class MesosTestEnvironment
extends TestEnvironmentBase
implements TestEnvironment {
    private boolean ready = false;

    @Override
    public synchronized void setUp() {
        this.ready = true;
    }

    @Override
    public synchronized Configuration getRuntimeConfiguration() {
        assert (this.ready);
        try {
            if (System.getenv("REEF_TEST_MESOS_MASTER_IP").equals("")) {
                throw new RuntimeException("REEF_TEST_MESOS_MASTER_IP unspecified");
            }
            String masterIp = System.getenv("REEF_TEST_MESOS_MASTER_IP");
            return MesosClientConfiguration.CONF.set((Param)MesosClientConfiguration.MASTER_IP, masterIp).build();
        }
        catch (BindException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public synchronized void tearDown() {
        assert (this.ready);
        this.ready = false;
    }

    @Override
    public int getTestTimeout() {
        return 300000;
    }
}

