/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests;

import org.apache.reef.io.ConfigurableDirectoryTempFileCreator;
import org.apache.reef.io.TempFileCreator;
import org.apache.reef.io.parameters.TempFileRootFolder;
import org.apache.reef.runtime.local.client.LocalRuntimeConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Configurations;
import org.apache.reef.tang.JavaConfigurationBuilder;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.TestEnvironment;
import org.apache.reef.tests.TestEnvironmentBase;

public final class LocalTestEnvironment
extends TestEnvironmentBase
implements TestEnvironment {
    public static final int MAX_NUMBER_OF_EVALUATORS = 4;
    private boolean ready = false;

    @Override
    public synchronized void setUp() {
        this.ready = true;
    }

    @Override
    public synchronized Configuration getRuntimeConfiguration() {
        assert (this.ready);
        String rootFolder = System.getProperty("org.apache.reef.runtime.local.folder");
        JavaConfigurationBuilder jcb = Tang.Factory.getTang().newConfigurationBuilder();
        jcb.bindNamedParameter(TempFileRootFolder.class, "./target/reef/temp");
        jcb.bindImplementation(TempFileCreator.class, ConfigurableDirectoryTempFileCreator.class);
        if (null == rootFolder) {
            return Configurations.merge((Configuration[])new Configuration[]{jcb.build(), LocalRuntimeConfiguration.CONF.set((Param)LocalRuntimeConfiguration.MAX_NUMBER_OF_EVALUATORS, (Number)4).set((Param)LocalRuntimeConfiguration.RUNTIME_ROOT_FOLDER, "target/REEF_LOCAL_RUNTIME").build()});
        }
        return Configurations.merge((Configuration[])new Configuration[]{jcb.build(), LocalRuntimeConfiguration.CONF.set((Param)LocalRuntimeConfiguration.MAX_NUMBER_OF_EVALUATORS, (Number)4).set((Param)LocalRuntimeConfiguration.RUNTIME_ROOT_FOLDER, rootFolder).build()});
    }

    @Override
    public synchronized void tearDown() {
        assert (this.ready);
        this.ready = false;
    }

    @Override
    public int getTestTimeout() {
        return 60000;
    }
}

