/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.client.yarnrest;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.reef.runtime.hdinsight.client.yarnrest.ApplicationID;
import org.apache.reef.runtime.hdinsight.client.yarnrest.ApplicationResponse;
import org.apache.reef.runtime.hdinsight.client.yarnrest.ApplicationState;
import org.apache.reef.runtime.hdinsight.client.yarnrest.ApplicationSubmission;
import org.apache.reef.runtime.hdinsight.client.yarnrest.ListApplicationResponse;
import org.apache.reef.runtime.hdinsight.parameters.HDInsightInstanceURL;
import org.apache.reef.runtime.hdinsight.parameters.HDInsightPassword;
import org.apache.reef.runtime.hdinsight.parameters.HDInsightUsername;
import org.apache.reef.tang.annotations.Parameter;
import org.codehaus.jackson.map.ObjectMapper;

public final class HDInsightInstance {
    private static final Logger LOG = Logger.getLogger(HDInsightInstance.class.getName());
    private static final String APPLICATION_KILL_MESSAGE = "{\"state\":\"KILLED\"}";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Header[] headers;
    private final HttpClientContext httpClientContext;
    private final String instanceUrl;
    private final CloseableHttpClient httpClient;

    @Inject
    HDInsightInstance(@Parameter(value=HDInsightUsername.class) String username, @Parameter(value=HDInsightPassword.class) String password, @Parameter(value=HDInsightInstanceURL.class) String instanceUrl, CloseableHttpClient client) throws URISyntaxException, IOException {
        this.httpClient = client;
        this.instanceUrl = instanceUrl.endsWith("/") ? instanceUrl : instanceUrl + "/";
        String host = this.getHost();
        this.headers = new Header[]{new BasicHeader("Host", host)};
        this.httpClientContext = this.getClientContext(host, username, password);
    }

    public ApplicationID getApplicationID() throws IOException {
        String url = "ws/v1/cluster/apps/new-application";
        HttpPost post = this.preparePost("ws/v1/cluster/apps/new-application");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post, (HttpContext)this.httpClientContext);){
            ApplicationID result;
            String message = IOUtils.toString((InputStream)response.getEntity().getContent());
            ApplicationID applicationID = result = (ApplicationID)this.objectMapper.readValue(message, ApplicationID.class);
            return applicationID;
        }
    }

    public void submitApplication(ApplicationSubmission applicationSubmission) throws IOException {
        String url = "ws/v1/cluster/apps";
        HttpPost post = this.preparePost("ws/v1/cluster/apps");
        StringWriter writer = new StringWriter();
        try {
            this.objectMapper.writeValue((Writer)writer, (Object)applicationSubmission);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String message = writer.toString();
        LOG.log(Level.FINE, "Sending:\n{0}", message.replace("\n", "\n\t"));
        post.setEntity((HttpEntity)new StringEntity(message, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post, (HttpContext)this.httpClientContext);){
            String responseMessage = IOUtils.toString((InputStream)response.getEntity().getContent());
            LOG.log(Level.FINE, "Response: {0}", responseMessage.replace("\n", "\n\t"));
        }
    }

    public void killApplication(String applicationId) throws IOException {
        String url = this.getApplicationURL(applicationId) + "/state";
        HttpPut put = this.preparePut(url);
        put.setEntity((HttpEntity)new StringEntity(APPLICATION_KILL_MESSAGE, ContentType.APPLICATION_JSON));
        this.httpClient.execute((HttpUriRequest)put, (HttpContext)this.httpClientContext);
    }

    public ApplicationState getApplication(String applicationId) throws IOException {
        String url = this.getApplicationURL(applicationId);
        HttpGet get = this.prepareGet(url);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get, (HttpContext)this.httpClientContext);){
            String message = IOUtils.toString((InputStream)response.getEntity().getContent());
            ApplicationResponse result = (ApplicationResponse)this.objectMapper.readValue(message, ApplicationResponse.class);
            ApplicationState applicationState = result.getApplicationState();
            return applicationState;
        }
    }

    public List<ApplicationState> listApplications() throws IOException {
        String url = "ws/v1/cluster/apps";
        HttpGet get = this.prepareGet("ws/v1/cluster/apps");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get, (HttpContext)this.httpClientContext);){
            String message = IOUtils.toString((InputStream)response.getEntity().getContent());
            ListApplicationResponse result = (ListApplicationResponse)this.objectMapper.readValue(message, ListApplicationResponse.class);
            List<ApplicationState> list = result.getApplicationStates();
            return list;
        }
    }

    public String getApplicationURL(String applicationId) {
        return "ws/v1/cluster/apps/" + applicationId;
    }

    private String getHost() throws URISyntaxException {
        URI uri = new URI(this.instanceUrl);
        return uri.getHost();
    }

    private HttpGet prepareGet(String url) {
        HttpGet httpGet = new HttpGet(this.instanceUrl + url);
        for (Header header : this.headers) {
            httpGet.addHeader(header);
        }
        return httpGet;
    }

    private HttpPost preparePost(String url) {
        HttpPost httpPost = new HttpPost(this.instanceUrl + url);
        for (Header header : this.headers) {
            httpPost.addHeader(header);
        }
        return httpPost;
    }

    private HttpPut preparePut(String url) {
        HttpPut httpPut = new HttpPut(this.instanceUrl + url);
        for (Header header : this.headers) {
            httpPut.addHeader(header);
        }
        return httpPut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClientContext getClientContext(String hostname, String username, String password) throws IOException {
        HttpClientContext result;
        block5: {
            HttpHost targetHost = new HttpHost(hostname, 443, "https");
            result = HttpClientContext.create();
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            result.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            result.setAuthCache((AuthCache)authCache);
            HttpGet httpget = new HttpGet("/");
            CloseableHttpResponse response = this.httpClient.execute(targetHost, (HttpRequest)httpget, (HttpContext)result);
            Throwable throwable = null;
            if (response == null) break block5;
            if (throwable != null) {
                try {
                    response.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                response.close();
            }
        }
        return result;
    }
}

