/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.client.yarnrest;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.reef.runtime.hdinsight.client.yarnrest.StringEntry;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class Credentials {
    private static final String CREDENTIALS = "credentials";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Map<String, List<StringEntry>> tokens = new HashMap<String, List<StringEntry>>();
    private Map<String, List<StringEntry>> secrets = new HashMap<String, List<StringEntry>>();

    public Credentials() {
        this.tokens.put("entry", new ArrayList());
        this.secrets.put("entry", new ArrayList());
    }

    public Credentials addSecret(String key, String value) {
        if (!this.secrets.containsKey("entry")) {
            this.secrets.put("entry", new ArrayList());
        }
        this.secrets.get("entry").add(new StringEntry(key, value));
        return this;
    }

    public Credentials addToken(String key, String value) {
        if (!this.tokens.containsKey("entry")) {
            this.tokens.put("entry", new ArrayList());
        }
        this.tokens.get("entry").add(new StringEntry(key, value));
        return this;
    }

    @JsonProperty(value="secrets")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public Map<String, List<StringEntry>> getSecrets() {
        return this.secrets;
    }

    public Credentials setSecrets(Map<String, List<StringEntry>> secrets) {
        this.secrets = secrets;
        return this;
    }

    @JsonProperty(value="tokens")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public Map<String, List<StringEntry>> getTokens() {
        return this.tokens;
    }

    public Credentials setTokens(Map<String, List<StringEntry>> tokens) {
        this.tokens = tokens;
        return this;
    }

    public String toString() {
        String objectString;
        StringWriter writer = new StringWriter();
        try {
            OBJECT_MAPPER.writeValue((Writer)writer, (Object)this);
            objectString = writer.toString();
        }
        catch (IOException e) {
            return null;
        }
        return CREDENTIALS + objectString;
    }
}

