/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.cli;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.apache.hadoop.io.file.tfile.TFile;

final class LogFileEntry {
    private static final Logger LOG = Logger.getLogger(LogFileEntry.class.getName());
    private final TFile.Reader.Scanner.Entry entry;

    LogFileEntry(TFile.Reader.Scanner.Entry entry) {
        this.entry = entry;
    }

    public void write(Writer outputWriter) throws IOException {
        try (DataInputStream keyStream = this.entry.getKeyStream();
             DataInputStream valueStream = this.entry.getValueStream();){
            outputWriter.write("Container: ");
            outputWriter.write(keyStream.readUTF());
            outputWriter.write("\n");
            this.writeFiles(valueStream, outputWriter);
        }
    }

    public void write(File folder) throws IOException {
        try (DataInputStream keyStream = this.entry.getKeyStream();
             DataInputStream valueStream = this.entry.getValueStream();){
            String containerId = keyStream.readUTF();
            try (OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(folder, containerId + ".txt")), StandardCharsets.UTF_8);){
                this.writeFiles(valueStream, outputWriter);
            }
        }
    }

    private void writeFiles(DataInputStream valueStream, Writer outputWriter) throws IOException {
        while (valueStream.available() > 0) {
            String strFileName = valueStream.readUTF();
            int entryLength = Integer.parseInt(valueStream.readUTF());
            outputWriter.write("=====================================================\n");
            outputWriter.write("File Name: " + strFileName + "\n");
            outputWriter.write("File Length: " + entryLength + "\n");
            outputWriter.write("-----------------------------------------------------\n");
            this.write(valueStream, outputWriter, entryLength);
            outputWriter.write("\n");
        }
    }

    private void write(DataInputStream stream, Writer outputWriter, int numberOfBytes) throws IOException {
        int len;
        byte[] buf = new byte[65535];
        for (int lenRemaining = numberOfBytes; lenRemaining > 0 && (len = stream.read(buf, 0, lenRemaining > 65535 ? 65535 : lenRemaining)) > 0; lenRemaining -= len) {
            outputWriter.write(new String(buf, 0, len, "UTF-8"));
        }
    }
}

