/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.client.yarnrest;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.reef.runtime.hdinsight.client.yarnrest.Commands;
import org.apache.reef.runtime.hdinsight.client.yarnrest.Credentials;
import org.apache.reef.runtime.hdinsight.client.yarnrest.LocalResource;
import org.apache.reef.runtime.hdinsight.client.yarnrest.LocalResourcesEntry;
import org.apache.reef.runtime.hdinsight.client.yarnrest.StringEntry;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public final class AmContainerSpec {
    public static final String ACLS_VIEW_APP = "VIEW_APP";
    public static final String ACLS_MODIFY_APP = "MODIFY_APP";
    private static final String AM_CONTAINER_SPEC = "AmContainerSpec";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Commands commands = new Commands();
    private Map<String, List<StringEntry>> environment = new HashMap<String, List<StringEntry>>();
    private Map<String, List<LocalResourcesEntry>> localResources = new HashMap<String, List<LocalResourcesEntry>>();
    private Map<String, List<StringEntry>> applicationAcls = new HashMap<String, List<StringEntry>>();
    private Map<String, List<StringEntry>> serviceData = new HashMap<String, List<StringEntry>>();
    private Credentials credentials;

    public AmContainerSpec() {
        this.localResources.put("entry", new ArrayList());
        this.environment.put("entry", new ArrayList());
        this.applicationAcls.put("entry", new ArrayList());
        this.serviceData.put("entry", new ArrayList());
    }

    public AmContainerSpec addEnvironment(String key, String value) {
        if (!this.environment.containsKey("entry")) {
            this.environment.put("entry", new ArrayList());
        }
        this.environment.get("entry").add(new StringEntry(key, value));
        return this;
    }

    public AmContainerSpec addLocalResource(String key, LocalResource localResource) {
        if (!this.localResources.containsKey("entry")) {
            this.localResources.put("entry", new ArrayList());
        }
        this.localResources.get("entry").add(new LocalResourcesEntry(key, localResource));
        return this;
    }

    public AmContainerSpec addApplicationAcl(String key, String value) {
        if (!this.applicationAcls.containsKey("entry")) {
            this.applicationAcls.put("entry", new ArrayList());
        }
        this.applicationAcls.get("entry").add(new StringEntry(key, value));
        return this;
    }

    public AmContainerSpec setCommand(String command) {
        this.commands.setCommand(command);
        return this;
    }

    public AmContainerSpec addServiceData(String key, String value) {
        if (!this.serviceData.containsKey("entry")) {
            this.serviceData.put("entry", new ArrayList());
        }
        this.serviceData.get("entry").add(new StringEntry(key, value));
        return this;
    }

    @JsonProperty(value="credentials")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public Credentials getCredentials() {
        return this.credentials;
    }

    public AmContainerSpec setCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @JsonProperty(value="service-data")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public Map<String, List<StringEntry>> getServiceData() {
        return this.serviceData;
    }

    public AmContainerSpec setServiceData(Map<String, List<StringEntry>> serviceData) {
        this.serviceData = serviceData;
        return this;
    }

    @JsonProperty(value="application-acls")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public Map<String, List<StringEntry>> getApplicationAcls() {
        return this.applicationAcls;
    }

    public AmContainerSpec setApplicationAcls(Map<String, List<StringEntry>> applicationAcls) {
        this.applicationAcls = applicationAcls;
        return this;
    }

    @JsonProperty(value="environment")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public Map<String, List<StringEntry>> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, List<StringEntry>> environment) {
        this.environment = environment;
    }

    @JsonProperty(value="commands")
    public Commands getCommands() {
        return this.commands;
    }

    public AmContainerSpec setCommands(Commands commands) {
        this.commands = commands;
        return this;
    }

    @JsonProperty(value="local-resources")
    public Map<String, List<LocalResourcesEntry>> getLocalResources() {
        return this.localResources;
    }

    public AmContainerSpec setLocalResources(Map<String, List<LocalResourcesEntry>> localResources) {
        this.localResources = localResources;
        return this;
    }

    public String toString() {
        String objectString;
        StringWriter writer = new StringWriter();
        try {
            OBJECT_MAPPER.writeValue((Writer)writer, (Object)this);
            objectString = writer.toString();
        }
        catch (IOException e) {
            return null;
        }
        return AM_CONTAINER_SPEC + objectString;
    }
}

