/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.client.sslhacks;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.reef.runtime.hdinsight.client.sslhacks.UnsafeHostNameVerifier;
import org.apache.reef.runtime.hdinsight.client.sslhacks.UnsafeTrustManager;
import org.apache.reef.tang.ExternalConstructor;

public final class UnsafeClientConstructor
implements ExternalConstructor<CloseableHttpClient> {
    @Inject
    UnsafeClientConstructor() {
        Logger.getLogger(UnsafeClientConstructor.class.getName()).log(Level.SEVERE, "DANGER: INSTANTIATING HTTP CLIENT WITH NO SSL CHECKS.");
    }

    public CloseableHttpClient newInstance() {
        try {
            SSLSocketFactory socketFactory = new SSLSocketFactory(this.getSSLContext());
            socketFactory.setHostnameVerifier((X509HostnameVerifier)new UnsafeHostNameVerifier());
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
            BasicClientConnectionManager clientConnectionManager = new BasicClientConnectionManager(schemeRegistry);
            return new DefaultHttpClient((ClientConnectionManager)clientConnectionManager);
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new RuntimeException("Unable to instantiate HTTP Client", ex);
        }
    }

    private SSLContext getSSLContext() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(new KeyManager[0], new TrustManager[]{new UnsafeTrustManager()}, new SecureRandom());
        return sc;
    }
}

