/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.client;

import java.io.File;
import java.io.IOException;
import org.apache.reef.runtime.hdinsight.client.UnsafeHDInsightRuntimeConfigurationStatic;
import org.apache.reef.runtime.hdinsight.parameters.AzureStorageAccountContainerName;
import org.apache.reef.runtime.hdinsight.parameters.AzureStorageAccountKey;
import org.apache.reef.runtime.hdinsight.parameters.AzureStorageAccountName;
import org.apache.reef.runtime.hdinsight.parameters.HDInsightInstanceURL;
import org.apache.reef.runtime.hdinsight.parameters.HDInsightPassword;
import org.apache.reef.runtime.hdinsight.parameters.HDInsightUsername;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.formats.AvroConfigurationSerializer;
import org.apache.reef.tang.formats.ConfigurationModule;
import org.apache.reef.tang.formats.ConfigurationModuleBuilder;
import org.apache.reef.tang.formats.RequiredParameter;

public final class UnsafeHDInsightRuntimeConfiguration
extends ConfigurationModuleBuilder {
    public static final RequiredParameter<String> URL = new RequiredParameter();
    public static final RequiredParameter<String> STORAGE_ACCOUNT_NAME = new RequiredParameter();
    public static final RequiredParameter<String> STORAGE_ACCOUNT_KEY = new RequiredParameter();
    public static final RequiredParameter<String> CONTAINER_NAME = new RequiredParameter();
    public static final RequiredParameter<String> USER_NAME = new RequiredParameter();
    public static final RequiredParameter<String> PASSWORD = new RequiredParameter();
    public static final ConfigurationModule CONF = new UnsafeHDInsightRuntimeConfiguration().merge(UnsafeHDInsightRuntimeConfigurationStatic.CONF).bindNamedParameter(AzureStorageAccountName.class, STORAGE_ACCOUNT_NAME).bindNamedParameter(AzureStorageAccountKey.class, STORAGE_ACCOUNT_KEY).bindNamedParameter(AzureStorageAccountContainerName.class, CONTAINER_NAME).bindNamedParameter(HDInsightInstanceURL.class, URL).bindNamedParameter(HDInsightUsername.class, USER_NAME).bindNamedParameter(HDInsightPassword.class, PASSWORD).build();

    public static Configuration fromTextFile(File file) throws IOException {
        return new AvroConfigurationSerializer().fromTextFile(file);
    }

    public static Configuration fromEnvironment() throws IOException {
        String configurationPath = System.getenv("REEF_HDI_CONF");
        if (null == configurationPath) {
            throw new IOException("Environment Variable REEF_HDI_CONF not set.");
        }
        File configurationFile = new File(configurationPath);
        if (!configurationFile.canRead()) {
            throw new IOException("Environment Variable REEF_HDI_CONF points to a file " + configurationFile.getAbsolutePath() + " which can't be read.");
        }
        return UnsafeHDInsightRuntimeConfiguration.fromTextFile(configurationFile);
    }
}

