/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.client;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.reef.annotations.audience.ClientSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.runtime.common.client.api.JobSubmissionEvent;
import org.apache.reef.runtime.common.client.api.JobSubmissionHandler;
import org.apache.reef.runtime.common.files.ClasspathProvider;
import org.apache.reef.runtime.common.files.JobJarMaker;
import org.apache.reef.runtime.common.files.REEFFileNames;
import org.apache.reef.runtime.common.launch.JavaLaunchCommandBuilder;
import org.apache.reef.runtime.common.parameters.JVMHeapSlack;
import org.apache.reef.runtime.hdinsight.client.AzureUploader;
import org.apache.reef.runtime.hdinsight.client.HDInsightDriverConfiguration;
import org.apache.reef.runtime.hdinsight.client.yarnrest.AmContainerSpec;
import org.apache.reef.runtime.hdinsight.client.yarnrest.ApplicationID;
import org.apache.reef.runtime.hdinsight.client.yarnrest.ApplicationSubmission;
import org.apache.reef.runtime.hdinsight.client.yarnrest.HDInsightInstance;
import org.apache.reef.runtime.hdinsight.client.yarnrest.LocalResource;
import org.apache.reef.runtime.hdinsight.client.yarnrest.Resource;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Configurations;
import org.apache.reef.tang.annotations.Parameter;

@ClientSide
@Private
public final class HDInsightJobSubmissionHandler
implements JobSubmissionHandler {
    private static final Logger LOG = Logger.getLogger(HDInsightJobSubmissionHandler.class.getName());
    private final AzureUploader uploader;
    private final JobJarMaker jobJarMaker;
    private final HDInsightInstance hdInsightInstance;
    private final REEFFileNames filenames;
    private final ClasspathProvider classpath;
    private final double jvmHeapSlack;

    @Inject
    HDInsightJobSubmissionHandler(AzureUploader uploader, JobJarMaker jobJarMaker, HDInsightInstance hdInsightInstance, REEFFileNames filenames, ClasspathProvider classpath, @Parameter(value=JVMHeapSlack.class) double jvmHeapSlack) {
        this.uploader = uploader;
        this.jobJarMaker = jobJarMaker;
        this.hdInsightInstance = hdInsightInstance;
        this.filenames = filenames;
        this.classpath = classpath;
        this.jvmHeapSlack = jvmHeapSlack;
    }

    public void close() {
        LOG.log(Level.WARNING, ".close() is inconsequential with the HDInsight runtime");
    }

    public void onNext(JobSubmissionEvent jobSubmissionEvent) {
        try {
            LOG.log(Level.FINE, "Requesting Application ID from HDInsight.");
            ApplicationID applicationID = this.hdInsightInstance.getApplicationID();
            LOG.log(Level.INFO, "Submitting application {0} to YARN.", applicationID.getApplicationId());
            LOG.log(Level.FINE, "Creating a job folder on Azure.");
            String jobFolderURL = this.uploader.createJobFolder(applicationID.getApplicationId());
            LOG.log(Level.FINE, "Assembling Configuration for the Driver.");
            Configuration driverConfiguration = this.makeDriverConfiguration(jobSubmissionEvent, applicationID.getApplicationId(), jobFolderURL);
            LOG.log(Level.FINE, "Making Job JAR.");
            File jobSubmissionJarFile = this.jobJarMaker.createJobSubmissionJAR(jobSubmissionEvent, driverConfiguration);
            LOG.log(Level.FINE, "Uploading Job JAR to Azure.");
            LocalResource uploadedFile = this.uploader.uploadFile(jobSubmissionJarFile);
            LOG.log(Level.FINE, "Assembling application submission.");
            String command = this.getCommandString(jobSubmissionEvent);
            ApplicationSubmission applicationSubmission = new ApplicationSubmission().setApplicationId(applicationID.getApplicationId()).setApplicationName(jobSubmissionEvent.getIdentifier()).setResource(this.getResource(jobSubmissionEvent)).setAmContainerSpec(new AmContainerSpec().addLocalResource(this.filenames.getREEFFolderName(), uploadedFile).setCommand(command));
            this.hdInsightInstance.submitApplication(applicationSubmission);
            LOG.log(Level.INFO, "Submitted application to HDInsight. The application id is: {0}", applicationID.getApplicationId());
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Error submitting HDInsight request", ex);
            throw new RuntimeException(ex);
        }
    }

    private Resource getResource(JobSubmissionEvent jobSubmissionEvent) {
        return new Resource().setMemory((Integer)jobSubmissionEvent.getDriverMemory().get()).setvCores(1);
    }

    private String getCommandString(JobSubmissionEvent jobSubmissionEvent) {
        return StringUtils.join(this.getCommandList(jobSubmissionEvent), (char)' ');
    }

    private List<String> getCommandList(JobSubmissionEvent jobSubmissionEvent) {
        return new JavaLaunchCommandBuilder().setJavaPath("%JAVA_HOME%/bin/java").setConfigurationFileName(this.filenames.getDriverConfigurationPath()).setClassPath((Collection)this.classpath.getDriverClasspath()).setMemory(((Integer)jobSubmissionEvent.getDriverMemory().get()).intValue()).setStandardErr("<LOG_DIR>/" + this.filenames.getDriverStderrFileName()).setStandardOut("<LOG_DIR>/" + this.filenames.getDriverStdoutFileName()).build();
    }

    private Configuration makeDriverConfiguration(JobSubmissionEvent jobSubmissionEvent, String applicationId, String jobFolderURL) throws IOException {
        Configuration hdinsightDriverConfiguration = HDInsightDriverConfiguration.CONF.set(HDInsightDriverConfiguration.JOB_IDENTIFIER, applicationId).set(HDInsightDriverConfiguration.CLIENT_REMOTE_IDENTIFIER, jobSubmissionEvent.getRemoteId()).set(HDInsightDriverConfiguration.JOB_SUBMISSION_DIRECTORY, jobFolderURL).set(HDInsightDriverConfiguration.JVM_HEAP_SLACK, (Number)this.jvmHeapSlack).build();
        return Configurations.merge((Configuration[])new Configuration[]{jobSubmissionEvent.getConfiguration(), hdinsightDriverConfiguration});
    }
}

