/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.cli;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.reef.runtime.hdinsight.cli.LogFileEntry;

final class TFileParser {
    private static final Logger LOG = Logger.getLogger(TFileParser.class.getName());
    private final FileSystem fileSystem;
    private final Configuration configuration;

    public TFileParser(Configuration conf, FileSystem fs) {
        this.configuration = conf;
        this.fileSystem = fs;
    }

    void parseOneFile(Path inputPath, Writer outputWriter) throws IOException {
        try (TFile.Reader.Scanner scanner = this.getScanner(inputPath);){
            while (!scanner.atEnd()) {
                new LogFileEntry(scanner.entry()).write(outputWriter);
                scanner.advance();
            }
        }
    }

    void parseOneFile(Path inputPath, File outputFolder) throws IOException {
        try (TFile.Reader.Scanner scanner = this.getScanner(inputPath);){
            while (!scanner.atEnd()) {
                new LogFileEntry(scanner.entry()).write(outputFolder);
                scanner.advance();
            }
        }
    }

    private TFile.Reader.Scanner getScanner(Path path) throws IOException {
        LOG.log(Level.FINE, "Creating Scanner for path {0}", path);
        TFile.Reader reader = new TFile.Reader(this.fileSystem.open(path), this.fileSystem.getFileStatus(path).getLen(), this.configuration);
        TFile.Reader.Scanner scanner = reader.createScanner();
        for (int counter = 0; counter < 3 && !scanner.atEnd(); ++counter) {
            scanner.advance();
        }
        LOG.log(Level.FINE, "Created Scanner for path {0}", path);
        return scanner;
    }
}

