/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.cli;

import com.microsoft.windowsazure.storage.CloudStorageAccount;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.blob.CloudBlob;
import com.microsoft.windowsazure.storage.blob.CloudBlobClient;
import com.microsoft.windowsazure.storage.blob.CloudBlobContainer;
import com.microsoft.windowsazure.storage.blob.CloudBlobDirectory;
import com.microsoft.windowsazure.storage.blob.ListBlobItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.reef.runtime.hdinsight.cli.TFileParser;
import org.apache.reef.runtime.hdinsight.parameters.AzureStorageAccountContainerName;
import org.apache.reef.runtime.hdinsight.parameters.AzureStorageAccountKey;
import org.apache.reef.runtime.hdinsight.parameters.AzureStorageAccountName;
import org.apache.reef.tang.annotations.Parameter;

final class LogFetcher {
    private static final String LOG_FOLDER_PREFIX = "app-logs/gopher/logs/";
    private static final Logger LOG = Logger.getLogger(LogFetcher.class.getName());
    private final CloudBlobContainer container;
    private final FileSystem fileSystem;
    private final Configuration hadoopConfiguration;
    private final TFileParser tFileParser;

    @Inject
    LogFetcher(@Parameter(value=AzureStorageAccountName.class) String accountName, @Parameter(value=AzureStorageAccountKey.class) String accountKey, @Parameter(value=AzureStorageAccountContainerName.class) String azureStorageContainerName) throws URISyntaxException, InvalidKeyException, StorageException, IOException {
        this.container = LogFetcher.getContainer(accountName, accountKey, azureStorageContainerName);
        this.hadoopConfiguration = new Configuration();
        this.fileSystem = FileSystem.get((Configuration)this.hadoopConfiguration);
        this.tFileParser = new TFileParser(this.hadoopConfiguration, this.fileSystem);
    }

    private static CloudBlobContainer getContainer(String accountName, String accountKey, String containerName) throws URISyntaxException, InvalidKeyException, StorageException {
        CloudStorageAccount cloudStorageAccount = CloudStorageAccount.parse((String)LogFetcher.getStorageConnectionString(accountName, accountKey));
        CloudBlobClient blobClient = cloudStorageAccount.createCloudBlobClient();
        return blobClient.getContainerReference(containerName);
    }

    private static String getStorageConnectionString(String accountName, String accountKey) {
        return "DefaultEndpointsProtocol=http;AccountName=" + accountName + ";AccountKey=" + accountKey;
    }

    void fetch(String applicationId, Writer outputWriter) throws IOException {
        try {
            for (FileStatus fileStatus : this.downloadLogs(applicationId)) {
                this.tFileParser.parseOneFile(fileStatus.getPath(), outputWriter);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    void fetch(String applicationId, File folder) throws IOException {
        try {
            for (FileStatus fileStatus : this.downloadLogs(applicationId)) {
                this.tFileParser.parseOneFile(fileStatus.getPath(), folder);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private FileStatus[] downloadLogs(String applicationId) throws StorageException, IOException, URISyntaxException {
        File localFolder = this.downloadToTempFolder(applicationId);
        Path localFolderPath = new Path(localFolder.getAbsolutePath());
        return this.fileSystem.listStatus(localFolderPath);
    }

    private File downloadToTempFolder(String applicationId) throws URISyntaxException, StorageException, IOException {
        File outputFolder = Files.createTempDirectory("reeflogs-" + applicationId, new FileAttribute[0]).toFile();
        outputFolder.mkdirs();
        CloudBlobDirectory logFolder = this.container.getDirectoryReference(LOG_FOLDER_PREFIX + applicationId + "/");
        int fileCounter = 0;
        for (ListBlobItem blobItem : logFolder.listBlobs()) {
            if (!(blobItem instanceof CloudBlob)) continue;
            FileOutputStream outputStream = new FileOutputStream(new File(outputFolder, "File-" + fileCounter));
            Throwable throwable = null;
            try {
                ((CloudBlob)blobItem).download((OutputStream)outputStream);
                ++fileCounter;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (outputStream == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                ((OutputStream)outputStream).close();
            }
        }
        LOG.log(Level.FINE, "Downloadeded logs to: {0}", outputFolder.getAbsolutePath());
        return outputFolder;
    }
}

