/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.client.yarnrest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.reef.runtime.hdinsight.client.yarnrest.EnvironmentEntry;
import org.apache.reef.runtime.hdinsight.client.yarnrest.FileResource;
import org.apache.reef.runtime.hdinsight.client.yarnrest.LocalResourcesEntry;

public final class ContainerInfo {
    public static final String DEFAULT_SERVICE_DATA = null;
    private String serviceData = DEFAULT_SERVICE_DATA;
    public static final String DEFAULT_TOKENS = "";
    private String tokens = "";
    public static final String DEFAULT_ACLS = null;
    private String acls = DEFAULT_ACLS;
    private List<String> commands = new ArrayList<String>();
    private Map<String, EnvironmentEntry> environment = new HashMap<String, EnvironmentEntry>();
    private Map<String, LocalResourcesEntry> localResources = new HashMap<String, LocalResourcesEntry>();

    public ContainerInfo addEnvironment(String key, String value) {
        this.environment.put("entry", new EnvironmentEntry(key, value));
        return this;
    }

    public ContainerInfo addCommand(String command) {
        this.commands.add(command);
        return this;
    }

    public ContainerInfo addFileResource(String key, FileResource fileResource) {
        this.localResources.put("entry", new LocalResourcesEntry(key, fileResource));
        return this;
    }

    public String getServiceData() {
        return this.serviceData;
    }

    public ContainerInfo setServiceData(String serviceData) {
        this.serviceData = serviceData;
        return this;
    }

    public String getTokens() {
        return this.tokens;
    }

    public ContainerInfo setTokens(String tokens) {
        this.tokens = tokens;
        return this;
    }

    public String getAcls() {
        return this.acls;
    }

    public ContainerInfo setAcls(String acls) {
        this.acls = acls;
        return this;
    }

    public Map<String, EnvironmentEntry> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, EnvironmentEntry> environment) {
        this.environment = environment;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public ContainerInfo setCommands(List<String> commands) {
        this.commands = commands;
        return this;
    }

    public Map<String, LocalResourcesEntry> getLocalResources() {
        return this.localResources;
    }

    public ContainerInfo setLocalResources(Map<String, LocalResourcesEntry> localResources) {
        this.localResources = localResources;
        return this;
    }
}

