/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.client;

import com.microsoft.windowsazure.storage.CloudStorageAccount;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.blob.BlobProperties;
import com.microsoft.windowsazure.storage.blob.CloudBlobClient;
import com.microsoft.windowsazure.storage.blob.CloudBlobContainer;
import com.microsoft.windowsazure.storage.blob.CloudBlockBlob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.annotations.audience.ClientSide;
import org.apache.reef.annotations.audience.Private;
import org.apache.reef.runtime.hdinsight.client.yarnrest.FileResource;
import org.apache.reef.runtime.hdinsight.parameters.AzureStorageAccountContainerName;
import org.apache.reef.runtime.hdinsight.parameters.AzureStorageAccountKey;
import org.apache.reef.runtime.hdinsight.parameters.AzureStorageAccountName;
import org.apache.reef.runtime.hdinsight.parameters.AzureStorageBaseFolder;
import org.apache.reef.tang.annotations.Parameter;

@ClientSide
@Private
final class AzureUploader {
    private static final Logger LOG = Logger.getLogger(AzureUploader.class.getName());
    private final CloudStorageAccount storageAccount;
    private final CloudBlobClient blobClient;
    private final CloudBlobContainer container;
    private final String azureStorageContainerName;
    private final String baseFolder;
    private String applicationID;
    private String jobFolderName;

    @Inject
    AzureUploader(@Parameter(value=AzureStorageAccountName.class) String accountName, @Parameter(value=AzureStorageAccountKey.class) String accountKey, @Parameter(value=AzureStorageAccountContainerName.class) String azureStorageContainerName, @Parameter(value=AzureStorageBaseFolder.class) String baseFolder) throws URISyntaxException, InvalidKeyException, StorageException {
        this.storageAccount = CloudStorageAccount.parse((String)AzureUploader.getStorageConnectionString(accountName, accountKey));
        this.blobClient = this.storageAccount.createCloudBlobClient();
        this.azureStorageContainerName = azureStorageContainerName;
        this.container = this.blobClient.getContainerReference(azureStorageContainerName);
        this.container.createIfNotExists();
        this.baseFolder = baseFolder;
        LOG.log(Level.FINE, "Instantiated AzureUploader connected to azure storage account: {0}", accountName);
    }

    private static String getStorageConnectionString(String accountName, String accountKey) {
        return "DefaultEndpointsProtocol=http;AccountName=" + accountName + ";AccountKey=" + accountKey;
    }

    public String createJobFolder(String applicationID) throws IOException {
        try {
            this.applicationID = applicationID;
            this.jobFolderName = this.assembleJobFolderName(applicationID);
            CloudBlockBlob jobFolderBlob = this.container.getBlockBlobReference(this.jobFolderName);
            String jobFolderURL = this.getFileSystemURL(jobFolderBlob);
            return jobFolderURL;
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException("Unable to create job Folder", e);
        }
    }

    public FileResource uploadFile(File file) throws IOException {
        String destination = this.jobFolderName + "/" + file.getName();
        LOG.log(Level.INFO, "Uploading [{0}] to [{1}]", new Object[]{file, destination});
        try {
            CloudBlockBlob jobJarBlob = this.container.getBlockBlobReference(destination);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                jobJarBlob.upload((InputStream)in, file.length());
            }
            if (!jobJarBlob.exists()) {
                LOG.log(Level.WARNING, "Blob doesn't exist!");
            }
            LOG.log(Level.FINE, "Uploaded to: {0}", jobJarBlob.getStorageUri().getPrimaryUri());
            BlobProperties blobProperties = jobJarBlob.getProperties();
            return new FileResource().setType("ARCHIVE").setVisibility("APPLICATION").setSize(String.valueOf(blobProperties.getLength())).setTimestamp(String.valueOf(blobProperties.getLastModified().getTime())).setUrl(this.getFileSystemURL(jobJarBlob));
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private String getFileSystemURL(CloudBlockBlob blob) {
        URI primaryURI = blob.getStorageUri().getPrimaryUri();
        String path = primaryURI.getPath().replace(this.azureStorageContainerName + "/", "");
        return "wasb://" + this.azureStorageContainerName + "@" + primaryURI.getHost() + path;
    }

    private String assembleJobFolderName(String applicationID) {
        return this.baseFolder + (this.baseFolder.endsWith("/") ? "" : "/") + applicationID;
    }
}

