/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.runtime.hdinsight.cli;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.reef.runtime.hdinsight.cli.LogFetcher;
import org.apache.reef.runtime.hdinsight.client.UnsafeHDInsightRuntimeConfiguration;
import org.apache.reef.runtime.hdinsight.client.yarnrest.ApplicationState;
import org.apache.reef.runtime.hdinsight.client.yarnrest.HDInsightInstance;
import org.apache.reef.tang.Tang;
import org.codehaus.jackson.map.ObjectMapper;

public final class HDICLI {
    private static final Logger LOG = Logger.getLogger(HDICLI.class.getName());
    private static final String KILL = "kill";
    private static final String LOGS = "logs";
    private static final String LIST = "list";
    private static final String STATUS = "status";
    private final HDInsightInstance hdInsightInstance;
    private final Options options;
    private final LogFetcher logFetcher;

    @Inject
    HDICLI(HDInsightInstance hdInsightInstance, LogFetcher logFetcher) {
        this.hdInsightInstance = hdInsightInstance;
        this.logFetcher = logFetcher;
        OptionGroup optionGroup = new OptionGroup();
        OptionBuilder.withArgName((String)KILL);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Kills the given application.");
        OptionGroup optionGroup2 = optionGroup.addOption(OptionBuilder.create((String)KILL));
        OptionBuilder.withArgName((String)LOGS);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Fetches the logs for the given application.");
        OptionGroup optionGroup3 = optionGroup2.addOption(OptionBuilder.create((String)LOGS));
        OptionBuilder.withArgName((String)STATUS);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Fetches the status for the given application.");
        OptionGroup optionGroup4 = optionGroup3.addOption(OptionBuilder.create((String)STATUS));
        OptionBuilder.withArgName((String)LIST);
        OptionBuilder.withDescription((String)"Lists the application on the cluster.");
        OptionGroup commands = optionGroup4.addOption(OptionBuilder.create((String)LIST));
        this.options = new Options().addOptionGroup(commands);
    }

    private static final void setupLogging() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
        System.setProperty(".level", "INFO");
    }

    public static void main(String[] args) throws Exception {
        HDICLI.setupLogging();
        ((HDICLI)Tang.Factory.getTang().newInjector(UnsafeHDInsightRuntimeConfiguration.fromEnvironment()).getInstance(HDICLI.class)).run(args);
    }

    public void run(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(this.options, args);
        List positionalArguments = line.getArgList();
        if (line.hasOption(KILL)) {
            this.kill(line.getOptionValue(KILL));
        } else if (line.hasOption(LOGS)) {
            String applicationId = line.getOptionValue(LOGS);
            if (positionalArguments.isEmpty()) {
                this.logs(applicationId);
            } else {
                this.logs(applicationId, new File((String)positionalArguments.get(0)));
            }
        } else if (line.hasOption(LIST)) {
            this.list();
        } else if (line.hasOption(STATUS)) {
            this.status(line.getOptionValue(STATUS));
        } else {
            throw new Exception("Unable to parse command line");
        }
    }

    private void kill(String applicationId) {
        LOG.log(Level.INFO, "Killing application [{0}]", applicationId);
        this.hdInsightInstance.killApplication(applicationId);
    }

    private void logs(String applicationId) throws IOException {
        LOG.log(Level.INFO, "Fetching logs for application [{0}]", applicationId);
        this.logFetcher.fetch(applicationId, new OutputStreamWriter(System.out));
    }

    private void logs(String applicationId, File folder) throws IOException {
        LOG.log(Level.FINE, "Fetching logs for application [{0}] and storing them in folder [{1}]", new Object[]{applicationId, folder.getAbsolutePath()});
        folder.mkdirs();
        this.logFetcher.fetch(applicationId, folder);
    }

    private void list() throws IOException {
        LOG.log(Level.FINE, "Listing applications");
        List<ApplicationState> applications = this.hdInsightInstance.listApplications();
        for (ApplicationState appState : applications) {
            if (!appState.getState().equals("RUNNING")) continue;
            System.out.println(appState.getId() + "\t" + appState.getName());
        }
    }

    private void status(String applicationId) throws IOException {
        List<ApplicationState> applications = this.hdInsightInstance.listApplications();
        ApplicationState applicationState = null;
        for (ApplicationState appState : applications) {
            if (!appState.getId().equals(applicationId)) continue;
            applicationState = appState;
            break;
        }
        if (applicationState == null) {
            throw new IOException("Unknown application: " + applicationId);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String status = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(applicationState);
        System.out.println(status);
    }
}

