/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util.logging;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public final class ThreadLogFormatter
extends Formatter {
    private static final String DEFAULT_FORMAT = "%1$tF %1$tT,%1$tL %4$s %2$s %7$s | %5$s%6$s%n";
    private final List<String> dropPrefix = new ArrayList<String>();
    private final Date date = new Date();
    private final String logFormat;

    public ThreadLogFormatter() {
        LogManager logManager = LogManager.getLogManager();
        String className = this.getClass().getName();
        String format = logManager.getProperty(className + ".format");
        this.logFormat = format != null ? format : DEFAULT_FORMAT;
        String rawDropStr = logManager.getProperty(className + ".dropPrefix");
        if (rawDropStr != null) {
            for (String prefix : rawDropStr.trim().split(",")) {
                if ((prefix = prefix.trim()).isEmpty()) continue;
                this.dropPrefix.add(prefix);
            }
        }
    }

    @Override
    public String format(LogRecord logRecord) {
        this.date.setTime(System.currentTimeMillis());
        return String.format(this.logFormat, this.date, this.trimPrefix(logRecord.getSourceClassName()) + "." + logRecord.getSourceMethodName(), logRecord.getLoggerName(), logRecord.getLevel().getLocalizedName(), this.formatMessage(logRecord), this.getStackTrace(logRecord.getThrown()), Thread.currentThread().getName());
    }

    private String trimPrefix(String className) {
        for (String prefix : this.dropPrefix) {
            if (!className.startsWith(prefix)) continue;
            return className.substring(prefix.length());
        }
        return className;
    }

    /*
     * Exception decompiling
     */
    private String getStackTrace(Throwable error) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

