/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.reef.util.Optional;
import org.apache.reef.util.logging.LoggingScope;

public class LoggingScopeImpl
implements LoggingScope {
    public static final String TOKEN = ":::";
    public static final String START_PREFIX = "START:::";
    public static final String EXIT_PREFIX = "EXIT:::";
    public static final String DURATION = " Duration = ";
    private final StopWatch stopWatch = new StopWatch();
    private final Logger logger;
    private final String msg;
    private final Object[] params;
    private final Optional<Object[]> optionalParams;
    private final Level logLevel;

    LoggingScopeImpl(Logger logger, Level logLevel, String msg, Object[] params) {
        this.logger = logger;
        this.logLevel = logLevel;
        this.msg = msg;
        this.params = params;
        this.stopWatch.start();
        this.optionalParams = Optional.ofNullable((Object)params);
        if (logger.isLoggable(logLevel)) {
            StringBuilder sb = new StringBuilder();
            this.log(sb.append(START_PREFIX).append(msg).toString());
        }
    }

    LoggingScopeImpl(Logger logger, Level logLevel, String msg) {
        this(logger, logLevel, msg, null);
    }

    @Override
    public void close() {
        this.stopWatch.stop();
        if (this.logger.isLoggable(this.logLevel)) {
            StringBuilder sb = new StringBuilder();
            this.log(sb.append(EXIT_PREFIX).append(this.msg).append(DURATION).append(this.stopWatch.getTime()).toString());
        }
    }

    private void log(String msg) {
        if (this.optionalParams.isPresent()) {
            this.logger.log(this.logLevel, msg, this.params);
        } else {
            this.logger.log(this.logLevel, msg);
        }
    }
}

