/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.util.logging.LogLevelName;
import org.apache.reef.util.logging.LoggingScope;
import org.apache.reef.util.logging.LoggingScopeImpl;
import org.apache.reef.wake.time.event.StartTime;

public class LoggingScopeFactory {
    private static final Logger LOG = Logger.getLogger(LoggingScopeFactory.class.getName());
    public static final String DRIVER_START = "Driver Start Handler";
    public static final String DRIVER_STOP = "Driver Stop Handler";
    public static final String BRIDGE_SETUP = "Bridge setup";
    public static final String LOAD_LIB = "Load libraries";
    public static final String EVALUATOR_REQUESTOR = "Evaluator requestor passed to C#";
    public static final String EVALUATOR_BRIDGE_SUBMIT = "Evaluator request submit cross bridge";
    public static final String EVALUATOR_SUBMIT = "Evaluator submit";
    public static final String EVALUATOR_LAUNCH = "Evaluator launch";
    public static final String EVALUATOR_ALLOCATED = "Evaluator allocated";
    public static final String EVALUATOR_COMPLETED = "Evaluator completed";
    public static final String EVALUATOR_FAILED = "Evaluator failed";
    public static final String ACTIVE_CONTEXT = "Active context created";
    public static final String TASK_RUNNING = "Task running";
    public static final String TASK_COMPLETE = "Task complete";
    public static final String TASK_MESSAGE = "Task message";
    public static final String CONTEXT_MESSAGE = "Context message";
    public static final String CONTEXT_CLOSE = "Context close";
    public static final String DRIVER_RESTART = "Driver restart";
    public static final String DRIVER_RESTART_COMPLETE = "Driver restart complete";
    public static final String DRIVER_RESTART_RUNNING_TASK = "Driver restart running task";
    public static final String DRIVER_RESTART_ACTIVE_CONTEXT = "Driver restart active context";
    public static final String TASK_SUSPEND = "Task suspend";
    public static final String DRIVER_SUBMIT = "Driver submit";
    public static final String REEF_SUBMIT = "Reef submit";
    public static final String LOCAL_JOB_SUBMIT = "Local job submit";
    public static final String HTTP_REQUEST = "Http request";
    public static final String HTTP_SERVER = "Http server";
    private final Level logLevel;

    @Inject
    private LoggingScopeFactory(@Parameter(value=LogLevelName.class) String logLevelName) {
        this.logLevel = Level.parse(logLevelName);
    }

    public static LoggingScope getNewLoggingScope(Level logLevel, String msg) {
        return new LoggingScopeImpl(LOG, logLevel, msg);
    }

    public LoggingScope getNewLoggingScope(String msg) {
        return new LoggingScopeImpl(LOG, this.logLevel, msg);
    }

    public LoggingScope getNewLoggingScope(String msg, Object[] params) {
        return new LoggingScopeImpl(LOG, this.logLevel, msg, params);
    }

    public LoggingScope driverStart(StartTime startTime) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Driver Start Handler :" + startTime);
    }

    public LoggingScope driverStop(long timeStamp) {
        return new LoggingScopeImpl(LOG, this.logLevel, DRIVER_STOP + " :" + timeStamp);
    }

    public LoggingScope setupBridge() {
        return new LoggingScopeImpl(LOG, this.logLevel, BRIDGE_SETUP);
    }

    public LoggingScope loadLib() {
        return new LoggingScopeImpl(LOG, this.logLevel, LOAD_LIB);
    }

    public LoggingScope evaluatorRequestorPassToCs() {
        return new LoggingScopeImpl(LOG, this.logLevel, EVALUATOR_REQUESTOR);
    }

    public LoggingScope evaluatorRequestSubmitToJavaDriver(int evaluatorsNumber) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Evaluator request submit cross bridge:" + evaluatorsNumber);
    }

    public LoggingScope evaluatorSubmit(int evaluatorNumber) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Evaluator submit:" + evaluatorNumber);
    }

    public LoggingScope evaluatorAllocated(String evaluatorId) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Evaluator allocated :" + evaluatorId);
    }

    public LoggingScope evaluatorLaunch(String evaluatorId) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Evaluator launch :" + evaluatorId);
    }

    public LoggingScope evaluatorCompleted(String evaluatorId) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Evaluator completed :" + evaluatorId);
    }

    public LoggingScope evaluatorFailed(String evaluatorId) {
        return new LoggingScopeImpl(LOG, this.logLevel, EVALUATOR_FAILED + " :" + evaluatorId);
    }

    public LoggingScope activeContextReceived(String contextId) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Active context created :" + contextId);
    }

    public LoggingScope closedContext(String contextId) {
        return new LoggingScopeImpl(LOG, this.logLevel, CONTEXT_CLOSE + " :" + contextId);
    }

    public LoggingScope taskRunning(String taskId) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Task running :" + taskId);
    }

    public LoggingScope taskCompleted(String taskId) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Task complete :" + taskId);
    }

    public LoggingScope taskSuspended(String taskId) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Task suspend :" + taskId);
    }

    public LoggingScope taskMessageReceived(String msg) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Task message :" + msg);
    }

    public LoggingScope contextMessageReceived(String msg) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Context message :" + msg);
    }

    public LoggingScope driverRestart(StartTime startTime) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Driver restart :" + startTime);
    }

    public LoggingScope driverRestartCompleted(long timeStamp) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Driver restart complete :" + timeStamp);
    }

    public LoggingScope driverRestartRunningTask(String taskId) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Driver restart running task :" + taskId);
    }

    public LoggingScope driverRestartActiveContextReceived(String contextId) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Driver restart active context :" + contextId);
    }

    public LoggingScope httpRequest(String uri) {
        return new LoggingScopeImpl(LOG, this.logLevel, HTTP_REQUEST + " :" + uri);
    }

    public LoggingScope httpServer() {
        return new LoggingScopeImpl(LOG, this.logLevel, HTTP_SERVER);
    }

    public LoggingScope driverSubmit(Boolean submitDriver) {
        return new LoggingScopeImpl(LOG, this.logLevel, "Driver submit :" + submitDriver);
    }

    public LoggingScope reefSubmit() {
        return new LoggingScopeImpl(LOG, this.logLevel, REEF_SUBMIT);
    }

    public LoggingScope localJobSubmission() {
        return new LoggingScopeImpl(LOG, this.logLevel, LOCAL_JOB_SUBMIT);
    }
}

