/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util.logging;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class LogParser {
    public static String[] endIndicators = new String[]{"EXIT:::Bridge setup", "EXIT:::Evaluator submit", "EXIT:::Evaluator request submit cross bridge", "EXIT:::Driver Start Handler", "EXIT:::Evaluator launch", "EXIT:::Evaluator allocated", "EXIT:::Active context created", "EXIT:::Http request", "EXIT:::Task complete"};
    public static String[] startIndicators = new String[]{"START:::Driver Start Handler", "START:::Bridge setup", "START:::Evaluator request submit cross bridge", "START:::Evaluator submit", "START:::Evaluator allocated", "START:::Evaluator launch", "START:::Active context created", "START:::Http request", "START:::Task complete"};

    private LogParser() {
    }

    public static ArrayList<String> getFilteredLinesFromFile(String fileName, String filter, String removeBeforeToken, String removeAfterToken) throws IOException {
        ArrayList<String> filteredLines = new ArrayList<String>();
        try (FileReader fr = new FileReader(fileName);
             BufferedReader in = new BufferedReader(fr);){
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] p;
                if (line.trim().length() == 0 || !line.contains(filter)) continue;
                String trimedLine = removeBeforeToken != null ? ((p = line.split(removeBeforeToken)).length > 1 ? p[p.length - 1] : line.trim()) : line.trim();
                if (removeAfterToken != null && (p = trimedLine.split(removeAfterToken)).length > 1) {
                    trimedLine = p[0];
                }
                filteredLines.add(trimedLine);
            }
        }
        return filteredLines;
    }

    public static ArrayList<String> getFilteredLinesFromFile(String fileName, String filter) throws IOException {
        return LogParser.getFilteredLinesFromFile(fileName, filter, null, null);
    }

    public static ArrayList<String> filter(ArrayList<String> original, String filter, String token) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : original) {
            String[] p;
            if (!line.contains(filter) || (p = line.split(token)).length <= 1) continue;
            result.add(p[p.length - 1]);
        }
        return result;
    }

    public static ArrayList<String> findStages(ArrayList<String> lines, String[] stageIndicators) {
        ArrayList<String> stages = new ArrayList<String>();
        int i = 0;
        for (String line : lines) {
            if (!line.contains(stageIndicators[i])) continue;
            stages.add(stageIndicators[i]);
            if (i >= stageIndicators.length - 1) continue;
            ++i;
        }
        return stages;
    }

    public static ArrayList<String> mergeStages(ArrayList<String> startStages, ArrayList<String> endStages) {
        ArrayList<String> mergeStage = new ArrayList<String>();
        for (int i = 0; i < startStages.size(); ++i) {
            String end = startStages.get(i).replace("START:::", "EXIT:::");
            if (endStages.contains(end)) {
                mergeStage.add(startStages.get(i) + "   " + end);
                continue;
            }
            mergeStage.add(startStages.get(i));
        }
        return mergeStage;
    }
}

