/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ThreadLogger {
    private ThreadLogger() {
    }

    public static void logThreads(Logger logger, Level level, String prefix) {
        ThreadLogger.logThreads(logger, level, prefix, "\n\t", "\n\t\t");
    }

    public static void logThreads(Logger logger, Level level, String prefix, String threadPrefix, String stackElementPrefix) {
        logger.log(level, ThreadLogger.getFormattedThreadList(prefix, threadPrefix, stackElementPrefix));
    }

    public static String getFormattedThreadList(String prefix, String threadPrefix, String stackElementPrefix) {
        StringBuilder message = new StringBuilder(prefix);
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            message.append(threadPrefix).append("Thread '").append(entry.getKey().getName()).append("':");
            for (StackTraceElement element : entry.getValue()) {
                message.append(stackElementPrefix).append(element.toString());
            }
        }
        return message.toString();
    }

    public static String getFormattedThreadList(String prefix) {
        return ThreadLogger.getFormattedThreadList(prefix, "\n\t", "\n\t\t");
    }

    public static void main(String[] args) {
        ThreadLogger.logThreads(Logger.getAnonymousLogger(), Level.INFO, "Threads active:");
    }
}

